package de.adorsys.opba.protocol.xs2a.service.mappers.generated;

import de.adorsys.opba.protocol.api.dto.context.UserAgentContext;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableRequest;
import de.adorsys.opba.protocol.api.dto.request.authorization.AuthorizationRequest;
import de.adorsys.opba.protocol.xs2a.context.ais.TransactionListXs2aContext;
import de.adorsys.opba.protocol.xs2a.entrypoint.authorization.common.UpdateAuthMapper.AisMapper;
import de.adorsys.opba.protocol.xs2a.entrypoint.authorization.common.UpdateAuthMapper.FromAisRequestTransactionList;
import de.adorsys.opba.protocol.xs2a.entrypoint.helpers.Xs2aUuidMapper;
import java.util.UUID;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-08T11:20:13+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_265 (Azul Systems, Inc.)"
)
@Component
public class UpdateAuthMapper$FromAisRequestTransactionListImpl implements FromAisRequestTransactionList {

    @Autowired
    private Xs2aUuidMapper xs2aUuidMapper;
    @Autowired
    private AisMapper aisMapper;

    @Override
    public void mapTo(AuthorizationRequest request, TransactionListXs2aContext context) {
        if ( request == null ) {
            return;
        }

        String psuIpPort = requestFacadeServiceableUaContextPsuIpPort( request );
        if ( psuIpPort != null ) {
            context.setPsuIpPort( psuIpPort );
        }
        String psuAccept = requestFacadeServiceableUaContextPsuAccept( request );
        if ( psuAccept != null ) {
            context.setContentType( psuAccept );
        }
        UUID requestId = requestFacadeServiceableRequestId( request );
        if ( requestId != null ) {
            context.setRequestId( xs2aUuidMapper.map( requestId ) );
        }
        String psuIpAddress = requestFacadeServiceableUaContextPsuIpAddress( request );
        if ( psuIpAddress != null ) {
            context.setPsuIpAddress( psuIpAddress );
        }
        if ( request.getAisConsent() != null ) {
            context.setAisConsent( aisMapper.map( request.getAisConsent() ) );
        }
    }

    private String requestFacadeServiceableUaContextPsuIpPort(AuthorizationRequest authorizationRequest) {
        if ( authorizationRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = authorizationRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        UserAgentContext uaContext = facadeServiceable.getUaContext();
        if ( uaContext == null ) {
            return null;
        }
        String psuIpPort = uaContext.getPsuIpPort();
        if ( psuIpPort == null ) {
            return null;
        }
        return psuIpPort;
    }

    private String requestFacadeServiceableUaContextPsuAccept(AuthorizationRequest authorizationRequest) {
        if ( authorizationRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = authorizationRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        UserAgentContext uaContext = facadeServiceable.getUaContext();
        if ( uaContext == null ) {
            return null;
        }
        String psuAccept = uaContext.getPsuAccept();
        if ( psuAccept == null ) {
            return null;
        }
        return psuAccept;
    }

    private UUID requestFacadeServiceableRequestId(AuthorizationRequest authorizationRequest) {
        if ( authorizationRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = authorizationRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        UUID requestId = facadeServiceable.getRequestId();
        if ( requestId == null ) {
            return null;
        }
        return requestId;
    }

    private String requestFacadeServiceableUaContextPsuIpAddress(AuthorizationRequest authorizationRequest) {
        if ( authorizationRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = authorizationRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        UserAgentContext uaContext = facadeServiceable.getUaContext();
        if ( uaContext == null ) {
            return null;
        }
        String psuIpAddress = uaContext.getPsuIpAddress();
        if ( psuIpAddress == null ) {
            return null;
        }
        return psuIpAddress;
    }
}
