package de.adorsys.opba.protocol.xs2a.service.mappers.generated;

import de.adorsys.opba.protocol.api.dto.request.payments.SinglePaymentBody;
import de.adorsys.opba.protocol.api.dto.result.body.AccountListBody;
import de.adorsys.opba.protocol.api.dto.result.body.AccountListBody.AccountListBodyBuilder;
import de.adorsys.opba.protocol.api.dto.result.body.AccountListDetailBody;
import de.adorsys.opba.protocol.api.dto.result.body.AccountListDetailBody.AccountListDetailBodyBuilder;
import de.adorsys.opba.protocol.api.dto.result.body.AccountReference;
import de.adorsys.opba.protocol.api.dto.result.body.AccountReference.AccountReferenceBuilder;
import de.adorsys.opba.protocol.api.dto.result.body.AccountReport.AccountReportBuilder;
import de.adorsys.opba.protocol.api.dto.result.body.Amount.AmountBuilder;
import de.adorsys.opba.protocol.api.dto.result.body.Balance;
import de.adorsys.opba.protocol.api.dto.result.body.Balance.BalanceBuilder;
import de.adorsys.opba.protocol.api.dto.result.body.TransactionDetailsBody;
import de.adorsys.opba.protocol.api.dto.result.body.TransactionDetailsBody.TransactionDetailsBodyBuilder;
import de.adorsys.opba.protocol.api.dto.result.body.TransactionListBody;
import de.adorsys.opba.protocol.api.dto.result.body.TransactionsResponseBody;
import de.adorsys.opba.protocol.api.dto.result.body.TransactionsResponseBody.TransactionsResponseBodyBuilder;
import de.adorsys.opba.protocol.xs2a.entrypoint.Xs2aResultBodyExtractor.Xs2aToFacadeMapper;
import de.adorsys.xs2a.adapter.service.model.AccountDetails;
import de.adorsys.xs2a.adapter.service.model.AccountListHolder;
import de.adorsys.xs2a.adapter.service.model.AccountReport;
import de.adorsys.xs2a.adapter.service.model.Address;
import de.adorsys.xs2a.adapter.service.model.Amount;
import de.adorsys.xs2a.adapter.service.model.SinglePaymentInitiationBody;
import de.adorsys.xs2a.adapter.service.model.Transactions;
import de.adorsys.xs2a.adapter.service.model.TransactionsReport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-08T16:25:22+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_265 (Azul Systems, Inc.)"
)
@Component
public class Xs2aResultBodyExtractor$Xs2aToFacadeMapperImpl implements Xs2aToFacadeMapper {

    @Override
    public AccountListBody map(AccountListHolder accountList) {
        if ( accountList == null ) {
            return null;
        }

        AccountListBodyBuilder accountListBody = AccountListBody.builder();

        accountListBody.accounts( accountDetailsListToAccountListDetailBodyList( accountList.getAccounts() ) );

        return accountListBody.build();
    }

    @Override
    public TransactionsResponseBody map(TransactionsReport transactions) {
        if ( transactions == null ) {
            return null;
        }

        TransactionsResponseBodyBuilder transactionsResponseBody = TransactionsResponseBody.builder();

        transactionsResponseBody.transactions( accountReportToAccountReport( transactions.getTransactions() ) );

        return transactionsResponseBody.build();
    }

    @Override
    public SinglePaymentBody map(SinglePaymentInitiationBody singlePaymentInitiationBody) {
        if ( singlePaymentInitiationBody == null ) {
            return null;
        }

        SinglePaymentBody singlePaymentBody = new SinglePaymentBody();

        singlePaymentBody.setCreditorAddress( addressToAddress( singlePaymentInitiationBody.getCreditorAddress() ) );
        singlePaymentBody.setCreditorAccount( accountReferenceToAccountReference( singlePaymentInitiationBody.getCreditorAccount() ) );
        singlePaymentBody.setCreditorAgent( singlePaymentInitiationBody.getCreditorAgent() );
        singlePaymentBody.setCreditorName( singlePaymentInitiationBody.getCreditorName() );
        singlePaymentBody.setDebtorAccount( accountReferenceToAccountReference( singlePaymentInitiationBody.getDebtorAccount() ) );
        singlePaymentBody.setEndToEndIdentification( singlePaymentInitiationBody.getEndToEndIdentification() );
        singlePaymentBody.setInstructedAmount( amountToAmount( singlePaymentInitiationBody.getInstructedAmount() ) );
        singlePaymentBody.setRemittanceInformationUnstructured( singlePaymentInitiationBody.getRemittanceInformationUnstructured() );

        return singlePaymentBody;
    }

    protected de.adorsys.opba.protocol.api.dto.result.body.Amount amountToAmount(Amount amount) {
        if ( amount == null ) {
            return null;
        }

        AmountBuilder amount1 = de.adorsys.opba.protocol.api.dto.result.body.Amount.builder();

        amount1.currency( amount.getCurrency() );
        amount1.amount( amount.getAmount() );

        return amount1.build();
    }

    protected Balance balanceToBalance(de.adorsys.xs2a.adapter.service.model.Balance balance) {
        if ( balance == null ) {
            return null;
        }

        BalanceBuilder balance1 = Balance.builder();

        balance1.balanceAmount( amountToAmount( balance.getBalanceAmount() ) );
        if ( balance.getBalanceType() != null ) {
            balance1.balanceType( balance.getBalanceType().name() );
        }
        balance1.lastChangeDateTime( balance.getLastChangeDateTime() );
        balance1.referenceDate( balance.getReferenceDate() );
        balance1.lastCommittedTransaction( balance.getLastCommittedTransaction() );

        return balance1.build();
    }

    protected List<Balance> balanceListToBalanceList(List<de.adorsys.xs2a.adapter.service.model.Balance> list) {
        if ( list == null ) {
            return null;
        }

        List<Balance> list1 = new ArrayList<Balance>( list.size() );
        for ( de.adorsys.xs2a.adapter.service.model.Balance balance : list ) {
            list1.add( balanceToBalance( balance ) );
        }

        return list1;
    }

    protected AccountListDetailBody accountDetailsToAccountListDetailBody(AccountDetails accountDetails) {
        if ( accountDetails == null ) {
            return null;
        }

        AccountListDetailBodyBuilder accountListDetailBody = AccountListDetailBody.builder();

        accountListDetailBody.resourceId( accountDetails.getResourceId() );
        accountListDetailBody.iban( accountDetails.getIban() );
        accountListDetailBody.bban( accountDetails.getBban() );
        accountListDetailBody.pan( accountDetails.getPan() );
        accountListDetailBody.maskedPan( accountDetails.getMaskedPan() );
        accountListDetailBody.msisdn( accountDetails.getMsisdn() );
        accountListDetailBody.currency( accountDetails.getCurrency() );
        accountListDetailBody.name( accountDetails.getName() );
        accountListDetailBody.product( accountDetails.getProduct() );
        if ( accountDetails.getCashAccountType() != null ) {
            accountListDetailBody.cashAccountType( accountDetails.getCashAccountType().name() );
        }
        if ( accountDetails.getStatus() != null ) {
            accountListDetailBody.status( accountDetails.getStatus().name() );
        }
        accountListDetailBody.bic( accountDetails.getBic() );
        accountListDetailBody.linkedAccounts( accountDetails.getLinkedAccounts() );
        accountListDetailBody.balances( balanceListToBalanceList( accountDetails.getBalances() ) );

        return accountListDetailBody.build();
    }

    protected List<AccountListDetailBody> accountDetailsListToAccountListDetailBodyList(List<AccountDetails> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountListDetailBody> list1 = new ArrayList<AccountListDetailBody>( list.size() );
        for ( AccountDetails accountDetails : list ) {
            list1.add( accountDetailsToAccountListDetailBody( accountDetails ) );
        }

        return list1;
    }

    protected AccountReference accountReferenceToAccountReference(de.adorsys.xs2a.adapter.service.model.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReferenceBuilder accountReference1 = AccountReference.builder();

        accountReference1.iban( accountReference.getIban() );
        accountReference1.bban( accountReference.getBban() );
        accountReference1.pan( accountReference.getPan() );
        accountReference1.maskedPan( accountReference.getMaskedPan() );
        accountReference1.msisdn( accountReference.getMsisdn() );
        accountReference1.currency( accountReference.getCurrency() );

        return accountReference1.build();
    }

    protected TransactionDetailsBody transactionsToTransactionDetailsBody(Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }

        TransactionDetailsBodyBuilder transactionDetailsBody = TransactionDetailsBody.builder();

        transactionDetailsBody.transactionId( transactions.getTransactionId() );
        transactionDetailsBody.entryReference( transactions.getEntryReference() );
        transactionDetailsBody.endToEndId( transactions.getEndToEndId() );
        transactionDetailsBody.mandateId( transactions.getMandateId() );
        transactionDetailsBody.checkId( transactions.getCheckId() );
        transactionDetailsBody.creditorId( transactions.getCreditorId() );
        transactionDetailsBody.bookingDate( transactions.getBookingDate() );
        transactionDetailsBody.valueDate( transactions.getValueDate() );
        transactionDetailsBody.transactionAmount( amountToAmount( transactions.getTransactionAmount() ) );
        transactionDetailsBody.creditorName( transactions.getCreditorName() );
        transactionDetailsBody.creditorAccount( accountReferenceToAccountReference( transactions.getCreditorAccount() ) );
        transactionDetailsBody.ultimateCreditor( transactions.getUltimateCreditor() );
        transactionDetailsBody.debtorName( transactions.getDebtorName() );
        transactionDetailsBody.debtorAccount( accountReferenceToAccountReference( transactions.getDebtorAccount() ) );
        transactionDetailsBody.ultimateDebtor( transactions.getUltimateDebtor() );
        transactionDetailsBody.remittanceInformationUnstructured( transactions.getRemittanceInformationUnstructured() );
        transactionDetailsBody.remittanceInformationStructured( map( transactions.getRemittanceInformationStructured() ) );
        transactionDetailsBody.proprietaryBankTransactionCode( transactions.getProprietaryBankTransactionCode() );

        return transactionDetailsBody.build();
    }

    protected TransactionListBody transactionsListToTransactionListBody(List<Transactions> list) {
        if ( list == null ) {
            return null;
        }

        TransactionListBody transactionListBody = new TransactionListBody();
        for ( Transactions transactions : list ) {
            transactionListBody.add( transactionsToTransactionDetailsBody( transactions ) );
        }

        return transactionListBody;
    }

    protected de.adorsys.opba.protocol.api.dto.result.body.AccountReport accountReportToAccountReport(AccountReport accountReport) {
        if ( accountReport == null ) {
            return null;
        }

        AccountReportBuilder accountReport1 = de.adorsys.opba.protocol.api.dto.result.body.AccountReport.builder();

        accountReport1.booked( transactionsListToTransactionListBody( accountReport.getBooked() ) );
        accountReport1.pending( transactionsListToTransactionListBody( accountReport.getPending() ) );

        return accountReport1.build();
    }

    protected de.adorsys.opba.protocol.api.dto.result.body.Address addressToAddress(Address address) {
        if ( address == null ) {
            return null;
        }

        de.adorsys.opba.protocol.api.dto.result.body.Address address1 = new de.adorsys.opba.protocol.api.dto.result.body.Address();

        address1.setCity( address.getTownName() );
        address1.setStreetName( address.getStreetName() );
        address1.setBuildingNumber( address.getBuildingNumber() );
        address1.setPostCode( address.getPostCode() );
        address1.setCountry( address.getCountry() );

        return address1;
    }
}
