package de.adorsys.opba.protocol.xs2a.service.mappers.generated;

import de.adorsys.opba.protocol.api.dto.context.UserAgentContext;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableRequest;
import de.adorsys.opba.protocol.api.dto.request.payments.InitiateSinglePaymentRequest;
import de.adorsys.opba.protocol.api.dto.request.payments.SinglePaymentBody;
import de.adorsys.opba.protocol.api.dto.result.body.AccountReference;
import de.adorsys.opba.protocol.api.dto.result.body.Address;
import de.adorsys.opba.protocol.api.dto.result.body.Amount;
import de.adorsys.opba.protocol.xs2a.context.pis.SinglePaymentXs2aContext;
import de.adorsys.opba.protocol.xs2a.entrypoint.helpers.Xs2aUuidMapper;
import de.adorsys.opba.protocol.xs2a.entrypoint.pis.Xs2aInitiateSinglePaymentEntrypoint.FromRequest;
import de.adorsys.opba.protocol.xs2a.service.xs2a.dto.payment.PaymentInitiateBody;
import de.adorsys.opba.protocol.xs2a.service.xs2a.dto.payment.PaymentInitiateBody.AccountReferenceBody;
import de.adorsys.opba.protocol.xs2a.service.xs2a.dto.payment.PaymentInitiateBody.AddressBody;
import de.adorsys.opba.protocol.xs2a.service.xs2a.dto.payment.PaymentInitiateBody.AmountBody;
import java.util.UUID;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-08T16:25:22+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_265 (Azul Systems, Inc.)"
)
@Component
public class Xs2aInitiateSinglePaymentEntrypoint$FromRequestImpl implements FromRequest {

    @Autowired
    private Xs2aUuidMapper xs2aUuidMapper;

    @Override
    public SinglePaymentXs2aContext map(InitiateSinglePaymentRequest ctx) {
        if ( ctx == null ) {
            return null;
        }

        SinglePaymentXs2aContext singlePaymentXs2aContext = new SinglePaymentXs2aContext();

        singlePaymentXs2aContext.setPayment( singlePaymentBodyToPaymentInitiateBody( ctx.getSinglePayment() ) );
        singlePaymentXs2aContext.setRequestId( xs2aUuidMapper.map( ctxFacadeServiceableRequestId( ctx ) ) );
        singlePaymentXs2aContext.setPaymentId( ctxSinglePaymentPaymentId( ctx ) );
        singlePaymentXs2aContext.setPsuIpAddress( ctxFacadeServiceableUaContextPsuIpAddress( ctx ) );
        singlePaymentXs2aContext.setFintechRedirectUriNok( ctxFacadeServiceableFintechRedirectUrlNok( ctx ) );
        singlePaymentXs2aContext.setFintechRedirectUriOk( ctxFacadeServiceableFintechRedirectUrlOk( ctx ) );
        String psuAccept = ctxFacadeServiceableUaContextPsuAccept( ctx );
        if ( psuAccept != null ) {
            singlePaymentXs2aContext.setContentType( psuAccept );
        }
        singlePaymentXs2aContext.setAspspId( ctxFacadeServiceableBankId( ctx ) );

        singlePaymentXs2aContext.setPaymentProduct( mapStandardPaymentProductToString(ctx.getSinglePayment().getPaymentProduct()) );

        return singlePaymentXs2aContext;
    }

    protected AddressBody addressToAddressBody(Address address) {
        if ( address == null ) {
            return null;
        }

        AddressBody addressBody = new AddressBody();

        addressBody.setStreetName( address.getStreetName() );
        addressBody.setBuildingNumber( address.getBuildingNumber() );
        addressBody.setCity( address.getCity() );
        addressBody.setPostCode( address.getPostCode() );
        addressBody.setCountry( address.getCountry() );

        return addressBody;
    }

    protected AccountReferenceBody accountReferenceToAccountReferenceBody(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReferenceBody accountReferenceBody = new AccountReferenceBody();

        accountReferenceBody.setIban( accountReference.getIban() );
        accountReferenceBody.setBban( accountReference.getBban() );
        accountReferenceBody.setPan( accountReference.getPan() );
        accountReferenceBody.setMaskedPan( accountReference.getMaskedPan() );
        accountReferenceBody.setMsisdn( accountReference.getMsisdn() );
        accountReferenceBody.setCurrency( accountReference.getCurrency() );

        return accountReferenceBody;
    }

    protected AmountBody amountToAmountBody(Amount amount) {
        if ( amount == null ) {
            return null;
        }

        AmountBody amountBody = new AmountBody();

        amountBody.setCurrency( amount.getCurrency() );
        amountBody.setAmount( amount.getAmount() );

        return amountBody;
    }

    protected PaymentInitiateBody singlePaymentBodyToPaymentInitiateBody(SinglePaymentBody singlePaymentBody) {
        if ( singlePaymentBody == null ) {
            return null;
        }

        PaymentInitiateBody paymentInitiateBody = new PaymentInitiateBody();

        paymentInitiateBody.setCreditorAddress( addressToAddressBody( singlePaymentBody.getCreditorAddress() ) );
        paymentInitiateBody.setDebtorAccount( accountReferenceToAccountReferenceBody( singlePaymentBody.getDebtorAccount() ) );
        paymentInitiateBody.setInstructedAmount( amountToAmountBody( singlePaymentBody.getInstructedAmount() ) );
        paymentInitiateBody.setCreditorAccount( accountReferenceToAccountReferenceBody( singlePaymentBody.getCreditorAccount() ) );
        paymentInitiateBody.setCreditorName( singlePaymentBody.getCreditorName() );
        paymentInitiateBody.setCreditorAgent( singlePaymentBody.getCreditorAgent() );
        paymentInitiateBody.setRemittanceInformationUnstructured( singlePaymentBody.getRemittanceInformationUnstructured() );
        paymentInitiateBody.setEndToEndIdentification( singlePaymentBody.getEndToEndIdentification() );

        return paymentInitiateBody;
    }

    private UUID ctxFacadeServiceableRequestId(InitiateSinglePaymentRequest initiateSinglePaymentRequest) {
        if ( initiateSinglePaymentRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = initiateSinglePaymentRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        UUID requestId = facadeServiceable.getRequestId();
        if ( requestId == null ) {
            return null;
        }
        return requestId;
    }

    private String ctxSinglePaymentPaymentId(InitiateSinglePaymentRequest initiateSinglePaymentRequest) {
        if ( initiateSinglePaymentRequest == null ) {
            return null;
        }
        SinglePaymentBody singlePayment = initiateSinglePaymentRequest.getSinglePayment();
        if ( singlePayment == null ) {
            return null;
        }
        String paymentId = singlePayment.getPaymentId();
        if ( paymentId == null ) {
            return null;
        }
        return paymentId;
    }

    private String ctxFacadeServiceableUaContextPsuIpAddress(InitiateSinglePaymentRequest initiateSinglePaymentRequest) {
        if ( initiateSinglePaymentRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = initiateSinglePaymentRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        UserAgentContext uaContext = facadeServiceable.getUaContext();
        if ( uaContext == null ) {
            return null;
        }
        String psuIpAddress = uaContext.getPsuIpAddress();
        if ( psuIpAddress == null ) {
            return null;
        }
        return psuIpAddress;
    }

    private String ctxFacadeServiceableFintechRedirectUrlNok(InitiateSinglePaymentRequest initiateSinglePaymentRequest) {
        if ( initiateSinglePaymentRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = initiateSinglePaymentRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        String fintechRedirectUrlNok = facadeServiceable.getFintechRedirectUrlNok();
        if ( fintechRedirectUrlNok == null ) {
            return null;
        }
        return fintechRedirectUrlNok;
    }

    private String ctxFacadeServiceableFintechRedirectUrlOk(InitiateSinglePaymentRequest initiateSinglePaymentRequest) {
        if ( initiateSinglePaymentRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = initiateSinglePaymentRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        String fintechRedirectUrlOk = facadeServiceable.getFintechRedirectUrlOk();
        if ( fintechRedirectUrlOk == null ) {
            return null;
        }
        return fintechRedirectUrlOk;
    }

    private String ctxFacadeServiceableUaContextPsuAccept(InitiateSinglePaymentRequest initiateSinglePaymentRequest) {
        if ( initiateSinglePaymentRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = initiateSinglePaymentRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        UserAgentContext uaContext = facadeServiceable.getUaContext();
        if ( uaContext == null ) {
            return null;
        }
        String psuAccept = uaContext.getPsuAccept();
        if ( psuAccept == null ) {
            return null;
        }
        return psuAccept;
    }

    private String ctxFacadeServiceableBankId(InitiateSinglePaymentRequest initiateSinglePaymentRequest) {
        if ( initiateSinglePaymentRequest == null ) {
            return null;
        }
        FacadeServiceableRequest facadeServiceable = initiateSinglePaymentRequest.getFacadeServiceable();
        if ( facadeServiceable == null ) {
            return null;
        }
        String bankId = facadeServiceable.getBankId();
        if ( bankId == null ) {
            return null;
        }
        return bankId;
    }
}
