/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.xs2a.tests.e2e.wiremock.mocks;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.tngtech.jgiven.annotation.ExpectedScenarioState;
import com.tngtech.jgiven.integration.spring.JGivenStage;
import de.adorsys.opba.protocol.xs2a.tests.e2e.stages.PaymentRequestCommon;
import de.adorsys.opba.protocol.xs2a.tests.e2e.stages.StagesCommonUtil;
import io.restassured.RestAssured;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.springframework.http.HttpStatus;

@JGivenStage
public class WiremockPaymentRequest<SELF extends WiremockPaymentRequest<SELF>>
extends PaymentRequestCommon<SELF> {
    @ExpectedScenarioState
    private WireMockServer wireMock;

    public SELF open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test() {
        return this.open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test(0);
    }

    public SELF open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test(int paymentCreationRequestIndex) {
        this.extractRedirectOkUriSentByOpbaFromWiremock(paymentCreationRequestIndex);
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)StagesCommonUtil.withSignatureHeaders((RequestSpecification)RestAssured.given().cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0])).when().get(this.redirectOkUri, new Object[0])).then()).statusCode(HttpStatus.SEE_OTHER.value())).extract();
        ((AbstractStringAssert)Assertions.assertThat((String)response.header("Location")).contains(new CharSequence[]{"pis"})).contains(new CharSequence[]{"consent-result"});
        return (SELF)((Object)((WiremockPaymentRequest)this.self()));
    }

    public SELF open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test_without_cookie_unauthorized() {
        this.extractRedirectOkUriSentByOpbaFromWiremock();
        ((ValidatableResponse)((ValidatableResponse)((Response)StagesCommonUtil.withSignatureHeaders((RequestSpecification)RestAssured.given()).when().get(this.redirectOkUri, new Object[0])).then()).statusCode(HttpStatus.UNAUTHORIZED.value())).extract();
        return (SELF)((Object)((WiremockPaymentRequest)this.self()));
    }

    public SELF open_banking_redirect_from_aspsp_with_static_oauth2_code_to_exchange_to_token(String code) {
        this.extractRedirectOkUriSentByOpbaFromWiremock();
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0]).when().get(this.redirectOkUri + "&code=" + code, new Object[0])).then()).statusCode(HttpStatus.SEE_OTHER.value())).extract();
        this.updateRedirectCode(response);
        return (SELF)((Object)((WiremockPaymentRequest)this.self()));
    }

    private void extractRedirectOkUriSentByOpbaFromWiremock() {
        this.extractRedirectOkUriSentByOpbaFromWiremock(0);
    }

    private void extractRedirectOkUriSentByOpbaFromWiremock(int paymentCreationRequestIndex) {
        LoggedRequest paymentInitiateRequest = (LoggedRequest)((List)Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.wireMock.findAll(WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)"/v1/payments/sepa-credit-transfers.*"))), it -> !it.isEmpty())).get(paymentCreationRequestIndex);
        this.redirectOkUri = paymentInitiateRequest.getHeader("TPP-Redirect-URI");
    }
}

