/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.xs2a.tests.e2e.wiremock.mocks;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.tngtech.jgiven.annotation.ExpectedScenarioState;
import com.tngtech.jgiven.integration.spring.JGivenStage;
import de.adorsys.opba.protocol.xs2a.tests.e2e.ResourceUtil;
import de.adorsys.opba.protocol.xs2a.tests.e2e.stages.AccountInformationRequestCommon;
import de.adorsys.opba.protocol.xs2a.tests.e2e.stages.StagesCommonUtil;
import io.restassured.RestAssured;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.springframework.http.HttpStatus;

@JGivenStage
public class WiremockAccountInformationRequest<SELF extends WiremockAccountInformationRequest<SELF>>
extends AccountInformationRequestCommon<SELF> {
    @ExpectedScenarioState
    private WireMockServer wireMock;

    public SELF open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test() {
        return this.open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test(0);
    }

    public SELF open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test(int consentCreationRequestIndex) {
        this.extractRedirectOkUriSentByOpbaFromWiremock(consentCreationRequestIndex);
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)StagesCommonUtil.withSignatureHeaders((RequestSpecification)RestAssured.given().cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0])).when().get(this.redirectOkUri, new Object[0])).then()).statusCode(HttpStatus.SEE_OTHER.value())).extract();
        ((AbstractStringAssert)Assertions.assertThat((String)response.header("Location")).contains(new CharSequence[]{"ais"})).contains(new CharSequence[]{"consent-result"});
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF open_banking_redirect_from_aspsp_with_static_oauth2_code_to_exchange_to_token(String code) {
        this.extractRedirectOkUriSentByOpbaFromWiremock();
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0]).when().get(this.redirectOkUri + "&code=" + code, new Object[0])).then()).statusCode(HttpStatus.SEE_OTHER.value())).extract();
        this.updateRedirectCode(response);
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF open_banking_redirect_from_aspsp_not_ok_webhook_called_for_api_test() {
        LoggedRequest consentInitiateRequest = (LoggedRequest)((List)Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.wireMock.findAll(WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)"/v1/consents.*"))), it -> !it.isEmpty())).get(0);
        this.redirectNotOkUri = consentInitiateRequest.getHeader("TPP-Nok-Redirect-URI");
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)StagesCommonUtil.withSignatureHeaders((RequestSpecification)RestAssured.given().cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0])).when().get(this.redirectNotOkUri, new Object[0])).then()).statusCode(HttpStatus.SEE_OTHER.value())).extract();
        Assertions.assertThat((String)response.header("Location")).contains(new CharSequence[]{"redirect-after-consent-denied"});
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF fintech_calls_list_accounts_for_anton_brueckner_ip_address_compute() {
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)StagesCommonUtil.withAccountsHeaders((String)"anton.brueckner").header("Service-Session-ID", (Object)UUID.randomUUID().toString(), new Object[0]).header("Compute-PSU-IP-Address", (Object)true, new Object[0]).when().get("/v1/banking/ais/accounts", new Object[0])).then()).statusCode(HttpStatus.ACCEPTED.value())).extract();
        this.updateServiceSessionId(response);
        this.updateRedirectCode(response);
        this.updateNextConsentAuthorizationUrl(response);
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF fintech_calls_list_accounts_for_anton_brueckner_no_ip_address() {
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)StagesCommonUtil.withAccountsHeaders((String)"anton.brueckner").header("Service-Session-ID", (Object)UUID.randomUUID().toString(), new Object[0]).header("Compute-PSU-IP-Address", (Object)false, new Object[0]).when().get("/v1/banking/ais/accounts", new Object[0])).then()).statusCode(HttpStatus.ACCEPTED.value())).extract();
        this.updateServiceSessionId(response);
        this.updateRedirectCode(response);
        this.updateNextConsentAuthorizationUrl(response);
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF user_anton_brueckner_provided_initial_parameters_but_without_psu_id_to_list_accounts_with_all_accounts_consent() {
        String body = ResourceUtil.readResource((String)"restrecord/tpp-ui-input/params/unknown-user-all-accounts-consent.json");
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("X-Request-ID", (Object)UUID.randomUUID().toString(), new Object[0]).header("X-XSRF-TOKEN", (Object)UUID.randomUUID().toString(), new Object[0]).cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0]).queryParam("redirectCode", new Object[]{this.redirectCode}).contentType("application/json").body(body).when().post("/v1/consent/{serviceSessionId}/embedded", new Object[]{this.serviceSessionId})).then()).statusCode(HttpStatus.ACCEPTED.value())).extract();
        ((AbstractStringAssert)Assertions.assertThat((String)response.header("Location")).contains(new CharSequence[]{"redirectCode"})).doesNotContain(new CharSequence[]{"consent-result"});
        this.responseContent = response.body().asString();
        this.redirectUriToGetUserParams = response.header("Location");
        this.updateRedirectCode(response);
        this.updateServiceSessionId(response);
        this.updateRedirectCode(response);
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF user_anton_brueckner_provided_initial_parameters_to_list_accounts_with_all_accounts_consent_with_ip_address_check() {
        String antonBruecknerParametersBody = ResourceUtil.readResource((String)"restrecord/tpp-ui-input/params/anton-brueckner-account-all-accounts-consent.json");
        return this.user_provided_initial_parameters_in_body_to_list_accounts_with_all_accounts_consent_with_ip_address_check(antonBruecknerParametersBody);
    }

    public SELF user_anton_brueckner_provided_psu_id_parameter_to_list_accounts_with_all_accounts_consent_with_ip_address_check() {
        String antonBruecknerPsuIdBody = ResourceUtil.readResource((String)"restrecord/tpp-ui-input/params/anton-brueckner-in-extras.json");
        return this.user_provided_initial_parameters_in_body_to_list_accounts_with_all_accounts_consent_with_ip_address_check(antonBruecknerPsuIdBody);
    }

    public SELF user_anton_brueckner_provided_initial_parameters_to_list_accounts_with_dedicated_consent() {
        String antonBruecknerParametersBody = ResourceUtil.readResource((String)"restrecord/tpp-ui-input/params/anton-brueckner-dedicated-account-consent.json");
        return this.user_provided_initial_parameters_in_body_to_list_accounts_with_all_accounts_consent_with_ip_address_check(antonBruecknerParametersBody);
    }

    public SELF user_provided_initial_parameters_in_body_to_list_accounts_with_all_accounts_consent_with_ip_address_check(String body) {
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("X-Request-ID", (Object)UUID.randomUUID().toString(), new Object[0]).header("X-XSRF-TOKEN", (Object)UUID.randomUUID().toString(), new Object[0]).cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0]).queryParam("redirectCode", new Object[]{this.redirectCode}).contentType("application/json").body(body).when().post("/v1/consent/{serviceSessionId}/embedded", new Object[]{this.serviceSessionId})).then()).statusCode(HttpStatus.ACCEPTED.value())).extract();
        LoggedRequest loggedRequest = (LoggedRequest)((List)Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.wireMock.findAll(WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)"/v1/consents.*"))), it -> !it.isEmpty())).get(0);
        Assertions.assertThat((String)loggedRequest.getHeader("PSU-IP-Address")).isNotEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)response.header("Location")).contains(new CharSequence[]{"ais"})).contains(new CharSequence[]{"to-aspsp-redirection"});
        this.responseContent = response.body().asString();
        this.redirectUriToGetUserParams = response.header("Location");
        this.updateRedirectCode(response);
        this.updateServiceSessionId(response);
        this.updateRedirectCode(response);
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF user_anton_brueckner_provided_initial_parameters_to_list_accounts_with_wrong_ibans() {
        String body = ResourceUtil.readResource((String)"restrecord/tpp-ui-input/params/anton-brueckner-account-wrong-ibans.json");
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("X-Request-ID", (Object)UUID.randomUUID().toString(), new Object[0]).header("X-XSRF-TOKEN", (Object)UUID.randomUUID().toString(), new Object[0]).queryParam("redirectCode", new Object[]{this.redirectCode}).cookie("Authorization-Session-Key", (Object)this.authSessionCookie, new Object[0]).contentType("application/json").body(body).when().post("/v1/consent/{serviceSessionId}/embedded", new Object[]{this.serviceSessionId})).then()).statusCode(HttpStatus.INTERNAL_SERVER_ERROR.value())).extract();
        this.responseContent = response.body().asString();
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF got_500_http_error_body() {
        Assertions.assertThat((String)this.responseContent).contains(new CharSequence[]{""});
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    public SELF open_banking_redirect_from_aspsp_ok_webhook_called_for_api_test_without_cookie_unauthorized() {
        this.extractRedirectOkUriSentByOpbaFromWiremock();
        ((ValidatableResponse)((ValidatableResponse)((Response)StagesCommonUtil.withSignatureHeaders((RequestSpecification)RestAssured.given()).when().get(this.redirectOkUri, new Object[0])).then()).statusCode(HttpStatus.UNAUTHORIZED.value())).extract();
        return (SELF)((Object)((WiremockAccountInformationRequest)this.self()));
    }

    private void extractRedirectOkUriSentByOpbaFromWiremock() {
        this.extractRedirectOkUriSentByOpbaFromWiremock(0);
    }

    private void extractRedirectOkUriSentByOpbaFromWiremock(int consentCreationRequestIndex) {
        LoggedRequest consentInitiateRequest = (LoggedRequest)((List)Awaitility.await().atMost(Durations.TEN_SECONDS).until(() -> this.wireMock.findAll(WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)"/v1/consents.*"))), it -> !it.isEmpty())).get(consentCreationRequestIndex);
        this.redirectOkUri = consentInitiateRequest.getHeader("TPP-Redirect-URI");
    }
}

