/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.service.exec;

import de.adorsys.opba.protocol.bpmnshared.dto.context.BaseContext;
import de.adorsys.opba.protocol.bpmnshared.dto.context.ContextMode;
import de.adorsys.opba.protocol.bpmnshared.service.context.ContextUtil;
import lombok.Generated;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.springframework.transaction.annotation.Transactional;

public abstract class ValidatedExecution<T extends BaseContext>
implements JavaDelegate {
    @Transactional(noRollbackFor={BpmnError.class})
    public void execute(DelegateExecution execution) {
        BaseContext context = ContextUtil.getContext(execution, BaseContext.class);
        this.doPrepareContext(execution, context);
        this.doValidate(execution, context);
        if (ContextMode.MOCK_REAL_CALLS == context.getMode()) {
            this.doMockedExecution(execution, context);
        } else {
            this.doRealExecution(execution, context);
        }
        this.doAfterCall(execution, context);
    }

    protected void doPrepareContext(DelegateExecution execution, T context) {
    }

    protected void doValidate(DelegateExecution execution, T context) {
    }

    protected abstract void doRealExecution(DelegateExecution var1, T var2);

    protected void doMockedExecution(DelegateExecution execution, T context) {
    }

    protected void doAfterCall(DelegateExecution execution, T context) {
    }

    @Generated
    public ValidatedExecution() {
    }
}

