/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.service.eventbus;

import de.adorsys.opba.protocol.bpmnshared.dto.messages.InternalProcessResult;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.ProcessError;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.ProcessErrorWithRootProcessId;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;

@Service
class ProcessResultEventHandler {
    private final Object lock = new Object();
    private final RuntimeService runtimeService;
    private final Map<String, Consumer<InternalProcessResult>> subscribers;
    private final Map<String, InternalProcessResult> deadLetterQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(String processId, Consumer<InternalProcessResult> subscriber) {
        InternalProcessResult delayedMessage;
        Object object = this.lock;
        synchronized (object) {
            delayedMessage = this.deadLetterQueue.remove(processId);
            if (null == delayedMessage) {
                this.subscribers.put(processId, subscriber);
                return;
            }
        }
        subscriber.accept(delayedMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionalEventListener
    public void handleEvent(InternalProcessResult result) {
        Consumer<InternalProcessResult> consumer;
        Object object = this.lock;
        synchronized (object) {
            InternalProcessResult handledResult = result;
            if (handledResult instanceof ProcessError) {
                handledResult = this.replaceErrorProcessIdWithParentProcessIdIfNeeded((ProcessError)handledResult);
            }
            if (null == (consumer = this.subscribers.remove(handledResult.getProcessId()))) {
                this.deadLetterQueue.put(handledResult.getProcessId(), result);
                return;
            }
        }
        consumer.accept(result);
    }

    private ProcessError replaceErrorProcessIdWithParentProcessIdIfNeeded(ProcessError error) {
        if (error instanceof ProcessErrorWithRootProcessId) {
            return error;
        }
        String rootProcessId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(error.getProcessId()).singleResult()).getRootProcessInstanceId();
        return error.toBuilder().processId(rootProcessId).build();
    }

    @ConstructorProperties(value={"runtimeService", "subscribers", "deadLetterQueue"})
    @Generated
    public ProcessResultEventHandler(RuntimeService runtimeService, Map<String, Consumer<InternalProcessResult>> subscribers, Map<String, InternalProcessResult> deadLetterQueue) {
        this.runtimeService = runtimeService;
        this.subscribers = subscribers;
        this.deadLetterQueue = deadLetterQueue;
    }
}

