/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.service.eventbus;

import de.adorsys.opba.protocol.bpmnshared.dto.messages.ConsentAcquired;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.InternalReturnableProcessError;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.ProcessResponse;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.Redirect;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.ValidationProblem;
import de.adorsys.opba.protocol.bpmnshared.outcome.OutcomeMapper;
import de.adorsys.opba.protocol.bpmnshared.service.eventbus.ProcessResultEventHandler;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcessEventHandlerRegistrar {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessEventHandlerRegistrar.class);
    private final ProcessResultEventHandler handler;

    public <T> void addHandler(String processId, OutcomeMapper<T> mapper) {
        this.handler.add(processId, procResult -> {
            if (procResult instanceof InternalReturnableProcessError) {
                mapper.onReturnableProcessError((InternalReturnableProcessError)procResult);
            } else if (procResult instanceof ProcessResponse) {
                mapper.onSuccess((ProcessResponse)procResult);
            } else if (procResult instanceof Redirect) {
                mapper.onRedirect((Redirect)procResult);
            } else if (procResult instanceof ValidationProblem) {
                mapper.onValidationProblem((ValidationProblem)procResult);
            } else if (procResult instanceof ConsentAcquired) {
                mapper.onConsentAcquired((ConsentAcquired)procResult);
            } else {
                mapper.onError();
            }
        });
    }

    @ConstructorProperties(value={"handler"})
    @Generated
    public ProcessEventHandlerRegistrar(ProcessResultEventHandler handler) {
        this.handler = handler;
    }
}

