/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.service.context;

import com.google.common.net.UrlEscapers;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;
import lombok.Generated;
import org.flowable.engine.delegate.DelegateExecution;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class ContextUtil {
    public static <T> T getContext(DelegateExecution execution, Class<T> ctxType) {
        return (T)execution.getVariable("CONTEXT", ctxType);
    }

    public static <T> void getAndUpdateContext(DelegateExecution execution, Consumer<T> contextUpdater) {
        Object ctx = execution.getVariable("CONTEXT");
        contextUpdater.accept(ctx);
        execution.setVariable("CONTEXT", ctx);
    }

    public static <R, T> R evaluateSpelForCtx(String expression, DelegateExecution execution, T context) {
        return (R)ContextUtil.evaluateSpelForCtx(expression, execution, context, Object.class);
    }

    public static <R, T> R evaluateSpelForCtx(String expression, DelegateExecution execution, T context, Class<R> resultClass) {
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext parseContext = new StandardEvaluationContext(new SpelCtx<T>(execution, context));
        return (R)parser.parseExpression(expression, (ParserContext)new TemplateParserContext()).getValue((EvaluationContext)parseContext, resultClass);
    }

    @Generated
    private ContextUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class SpelCtx<T> {
        private final DelegateExecution execution;
        private final T context;

        public String urlSafe(String original) {
            return UrlEscapers.urlPathSegmentEscaper().escape(original);
        }

        @Generated
        public DelegateExecution getExecution() {
            return this.execution;
        }

        @Generated
        public T getContext() {
            return this.context;
        }

        @ConstructorProperties(value={"execution", "context"})
        @Generated
        public SpelCtx(DelegateExecution execution, T context) {
            this.execution = execution;
            this.context = context;
        }
    }
}

