/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.config.flowable.expirable;

import com.google.common.cache.CacheBuilder;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.FlowableProperties;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.InternalProcessResult;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExpirableDataConfig {
    private static final String PROTOCOL_CACHE_BUILDER = "protocol-cache-builder";
    public static final long MIN_EXPIRE_SECONDS = 60L;

    @Bean(value={"protocol-cache-builder"})
    CacheBuilder protocolCacheBuilder(FlowableProperties flowableProperties) {
        Duration expireAfterWrite = flowableProperties.getExpirable().getExpireAfterWrite();
        if (expireAfterWrite.getSeconds() < 60L) {
            throw new IllegalArgumentException("It is not recommended to have short transient data expiration time, it must be at least equal to request timeout");
        }
        return CacheBuilder.newBuilder().expireAfterWrite(expireAfterWrite).maximumSize(Integer.MAX_VALUE);
    }

    @Bean
    Map<String, Consumer<InternalProcessResult>> subscribers(@Qualifier(value="protocol-cache-builder") CacheBuilder builder) {
        return builder.build().asMap();
    }

    @Bean
    Map<String, InternalProcessResult> deadLetterQueue(@Qualifier(value="protocol-cache-builder") CacheBuilder builder) {
        return builder.build().asMap();
    }
}

