/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.config.flowable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import de.adorsys.opba.protocol.api.services.scoped.RequestScoped;
import de.adorsys.opba.protocol.api.services.scoped.RequestScopedServicesProvider;
import de.adorsys.opba.protocol.api.services.scoped.UsesRequestScoped;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class SerializerUtil {
    public static boolean canSerialize(String canonicalName, List<String> allowOnlyClassesWithPrefix) {
        return allowOnlyClassesWithPrefix.stream().anyMatch(canonicalName::startsWith);
    }

    public static byte[] serialize(@NotNull Object data, @NotNull ObjectMapper mapper) {
        if (!(data instanceof RequestScoped)) {
            throw new IllegalStateException("Can't serialize non-request scoped classes");
        }
        return mapper.writeValueAsBytes((Object)ImmutableMap.of((Object)data.getClass().getCanonicalName(), (Object)new EncryptedContainer((RequestScoped)data, mapper)));
    }

    public static Object deserialize(@NotNull byte[] bytes, @NotNull ObjectMapper mapper, @NotNull List<String> allowOnlyClassesWithPrefix, @NotNull RequestScopedServicesProvider requestScoped) {
        JsonNode value = mapper.readTree(bytes);
        Map.Entry classNameAndValue = (Map.Entry)value.fields().next();
        if (!SerializerUtil.canSerialize((String)classNameAndValue.getKey(), allowOnlyClassesWithPrefix)) {
            throw new IllegalArgumentException("Class deserialization not allowed " + (String)classNameAndValue.getKey());
        }
        Class<?> dataClazz = Class.forName((String)classNameAndValue.getKey());
        if (!RequestScoped.class.isAssignableFrom(dataClazz)) {
            throw new IllegalStateException("Can't deserialize non-request scoped classes");
        }
        EncryptedContainer container = (EncryptedContainer)mapper.readValue(((JsonNode)classNameAndValue.getValue()).traverse(), EncryptedContainer.class);
        RequestScoped services = requestScoped.findRegisteredByKeyId(container.getEncKeyId());
        if (null == services) {
            throw new IllegalStateException("Missing request scoped service for key: " + container.getEncKeyId());
        }
        Object result = mapper.readValue(services.encryption().decrypt(container.getData()), dataClazz);
        if (result instanceof UsesRequestScoped) {
            ((UsesRequestScoped)result).setRequestScoped(services);
        }
        return result;
    }

    @Generated
    private SerializerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class EncryptedContainer {
        private String encKeyId;
        private byte[] data;

        EncryptedContainer(RequestScoped requestScoped, ObjectMapper mapper) {
            if (null == requestScoped || null == requestScoped.encryption()) {
                throw new IllegalStateException("Missing encryption service");
            }
            this.encKeyId = requestScoped.getEncryptionKeyId();
            this.data = requestScoped.encryption().encrypt(mapper.writeValueAsBytes((Object)requestScoped));
        }

        @Generated
        public String getEncKeyId() {
            return this.encKeyId;
        }

        @Generated
        public byte[] getData() {
            return this.data;
        }

        @Generated
        public void setEncKeyId(String encKeyId) {
            this.encKeyId = encKeyId;
        }

        @Generated
        public void setData(byte[] data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncryptedContainer)) {
                return false;
            }
            EncryptedContainer other = (EncryptedContainer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$encKeyId = this.getEncKeyId();
            String other$encKeyId = other.getEncKeyId();
            if (this$encKeyId == null ? other$encKeyId != null : !this$encKeyId.equals(other$encKeyId)) {
                return false;
            }
            return Arrays.equals(this.getData(), other.getData());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EncryptedContainer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $encKeyId = this.getEncKeyId();
            result = result * 59 + ($encKeyId == null ? 43 : $encKeyId.hashCode());
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        @Generated
        public String toString() {
            return "SerializerUtil.EncryptedContainer(encKeyId=" + this.getEncKeyId() + ", data=" + Arrays.toString(this.getData()) + ")";
        }

        @Generated
        public EncryptedContainer() {
        }

        @ConstructorProperties(value={"encKeyId", "data"})
        @Generated
        public EncryptedContainer(String encKeyId, byte[] data) {
            this.encKeyId = encKeyId;
            this.data = data;
        }
    }
}

