/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.config.flowable;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.protocol.api.services.scoped.RequestScopedServicesProvider;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.SerializerUtil;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.service.impl.types.SerializableType;

public class LargeJsonCustomSerializer
extends SerializableType {
    static final String JSON = "as_large_json";
    private final RequestScopedServicesProvider scopedServicesProvider;
    private final ObjectMapper mapper;
    private final List<String> allowOnlyClassesWithPrefix;
    private final int minLength;

    public String getTypeName() {
        return JSON;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isAbleToStore(Object o) {
        if (o == null) {
            return true;
        }
        if (!SerializerUtil.canSerialize(o.getClass().getCanonicalName(), this.allowOnlyClassesWithPrefix)) {
            return false;
        }
        String value = this.mapper.writeValueAsString(o);
        return value.length() > this.minLength;
    }

    public byte[] serialize(Object o, ValueFields valueFields) {
        if (o == null) {
            return null;
        }
        return SerializerUtil.serialize(o, this.mapper);
    }

    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        if (null == bytes) {
            return null;
        }
        return SerializerUtil.deserialize(bytes, this.mapper, this.allowOnlyClassesWithPrefix, this.scopedServicesProvider);
    }

    @ConstructorProperties(value={"scopedServicesProvider", "mapper", "allowOnlyClassesWithPrefix", "minLength"})
    @Generated
    public LargeJsonCustomSerializer(RequestScopedServicesProvider scopedServicesProvider, ObjectMapper mapper, List<String> allowOnlyClassesWithPrefix, int minLength) {
        this.scopedServicesProvider = scopedServicesProvider;
        this.mapper = mapper;
        this.allowOnlyClassesWithPrefix = allowOnlyClassesWithPrefix;
        this.minLength = minLength;
    }
}

