/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.config.flowable;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.protocol.api.services.scoped.RequestScopedServicesProvider;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.SerializerUtil;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class JsonCustomSerializer
implements VariableType {
    static final String JSON = "as_json";
    private final RequestScopedServicesProvider scopedServicesProvider;
    private final ObjectMapper mapper;
    private final List<String> allowOnlyClassesWithPrefix;
    private final int maxLength;

    public String getTypeName() {
        return JSON;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isAbleToStore(Object o) {
        if (o == null) {
            return true;
        }
        if (!SerializerUtil.canSerialize(o.getClass().getCanonicalName(), this.allowOnlyClassesWithPrefix)) {
            return false;
        }
        String value = this.mapper.writeValueAsString(o);
        return value.length() <= this.maxLength;
    }

    public void setValue(Object o, ValueFields valueFields) {
        if (o == null) {
            valueFields.setBytes(null);
            return;
        }
        valueFields.setBytes(SerializerUtil.serialize(o, this.mapper));
    }

    public Object getValue(ValueFields valueFields) {
        if (null == valueFields.getBytes()) {
            return null;
        }
        return SerializerUtil.deserialize(valueFields.getBytes(), this.mapper, this.allowOnlyClassesWithPrefix, this.scopedServicesProvider);
    }

    @ConstructorProperties(value={"scopedServicesProvider", "mapper", "allowOnlyClassesWithPrefix", "maxLength"})
    @Generated
    public JsonCustomSerializer(RequestScopedServicesProvider scopedServicesProvider, ObjectMapper mapper, List<String> allowOnlyClassesWithPrefix, int maxLength) {
        this.scopedServicesProvider = scopedServicesProvider;
        this.mapper = mapper;
        this.allowOnlyClassesWithPrefix = allowOnlyClassesWithPrefix;
        this.maxLength = maxLength;
    }
}

