/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.config.flowable;

import de.adorsys.opba.protocol.bpmnshared.config.flowable.SerializerUtil;
import java.time.Duration;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="bpmnshared.flowable")
public class FlowableProperties {
    @Min(value=0L)
    private @Min(value=0L) int numberOfRetries = 3;
    @NotNull
    private Serialization serialization;
    @NotNull
    private Expirable expirable;

    @Generated
    public FlowableProperties() {
    }

    @Generated
    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    @Generated
    public Serialization getSerialization() {
        return this.serialization;
    }

    @Generated
    public Expirable getExpirable() {
        return this.expirable;
    }

    @Generated
    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    @Generated
    public void setSerialization(Serialization serialization) {
        this.serialization = serialization;
    }

    @Generated
    public void setExpirable(Expirable expirable) {
        this.expirable = expirable;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowableProperties)) {
            return false;
        }
        FlowableProperties other = (FlowableProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfRetries() != other.getNumberOfRetries()) {
            return false;
        }
        Serialization this$serialization = this.getSerialization();
        Serialization other$serialization = other.getSerialization();
        if (this$serialization == null ? other$serialization != null : !((Object)this$serialization).equals(other$serialization)) {
            return false;
        }
        Expirable this$expirable = this.getExpirable();
        Expirable other$expirable = other.getExpirable();
        return !(this$expirable == null ? other$expirable != null : !((Object)this$expirable).equals(other$expirable));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowableProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberOfRetries();
        Serialization $serialization = this.getSerialization();
        result = result * 59 + ($serialization == null ? 43 : ((Object)$serialization).hashCode());
        Expirable $expirable = this.getExpirable();
        result = result * 59 + ($expirable == null ? 43 : ((Object)$expirable).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlowableProperties(numberOfRetries=" + this.getNumberOfRetries() + ", serialization=" + this.getSerialization() + ", expirable=" + this.getExpirable() + ")";
    }

    @Configuration
    public static class Expirable {
        @NotNull
        private Duration expireAfterWrite;

        @Generated
        public Expirable() {
        }

        @Generated
        public Duration getExpireAfterWrite() {
            return this.expireAfterWrite;
        }

        @Generated
        public void setExpireAfterWrite(Duration expireAfterWrite) {
            this.expireAfterWrite = expireAfterWrite;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Expirable)) {
                return false;
            }
            Expirable other = (Expirable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$expireAfterWrite = this.getExpireAfterWrite();
            Duration other$expireAfterWrite = other.getExpireAfterWrite();
            return !(this$expireAfterWrite == null ? other$expireAfterWrite != null : !((Object)this$expireAfterWrite).equals(other$expireAfterWrite));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Expirable;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $expireAfterWrite = this.getExpireAfterWrite();
            result = result * 59 + ($expireAfterWrite == null ? 43 : ((Object)$expireAfterWrite).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FlowableProperties.Expirable(expireAfterWrite=" + this.getExpireAfterWrite() + ")";
        }
    }

    @Configuration
    public static class Serialization {
        private @NotEmpty List<@NotBlank String> serializeOnlyPackages;
        @Min(value=-1L)
        private @Min(value=-1L) int maxLength = 2048;

        public boolean canSerialize(String canonicalName) {
            return SerializerUtil.canSerialize(canonicalName, this.serializeOnlyPackages);
        }

        @Generated
        public Serialization() {
        }

        @Generated
        public List<@NotBlank String> getSerializeOnlyPackages() {
            return this.serializeOnlyPackages;
        }

        @Generated
        public int getMaxLength() {
            return this.maxLength;
        }

        @Generated
        public void setSerializeOnlyPackages(List<@NotBlank String> serializeOnlyPackages) {
            this.serializeOnlyPackages = serializeOnlyPackages;
        }

        @Generated
        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Serialization)) {
                return false;
            }
            Serialization other = (Serialization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$serializeOnlyPackages = this.getSerializeOnlyPackages();
            List<String> other$serializeOnlyPackages = other.getSerializeOnlyPackages();
            if (this$serializeOnlyPackages == null ? other$serializeOnlyPackages != null : !((Object)this$serializeOnlyPackages).equals(other$serializeOnlyPackages)) {
                return false;
            }
            return this.getMaxLength() == other.getMaxLength();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Serialization;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $serializeOnlyPackages = this.getSerializeOnlyPackages();
            result = result * 59 + ($serializeOnlyPackages == null ? 43 : ((Object)$serializeOnlyPackages).hashCode());
            result = result * 59 + this.getMaxLength();
            return result;
        }

        @Generated
        public String toString() {
            return "FlowableProperties.Serialization(serializeOnlyPackages=" + this.getSerializeOnlyPackages() + ", maxLength=" + this.getMaxLength() + ")";
        }
    }
}

