/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.config.flowable;

import com.google.common.collect.ImmutableSet;
import de.adorsys.opba.protocol.bpmnshared.dto.messages.ProcessError;
import java.util.Set;
import lombok.Generated;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableExceptionEvent;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FlowableJobEventListener
extends AbstractFlowableEngineEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowableJobEventListener.class);
    private final ApplicationEventPublisher applicationEventPublisher;

    public FlowableJobEventListener(ApplicationEventPublisher applicationEventPublisher) {
        super((Set)ImmutableSet.of((Object)FlowableEngineEventType.JOB_EXECUTION_FAILURE, (Object)FlowableEngineEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT));
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void jobExecutionFailure(FlowableEngineEntityEvent event) {
        this.handleError(event);
    }

    protected void processCompletedWithErrorEnd(FlowableEngineEntityEvent event) {
        this.handleError(event);
    }

    private void handleError(FlowableEngineEntityEvent event) {
        if (event instanceof FlowableExceptionEvent) {
            log.error("Exception occurred for execution {} of process {}", new Object[]{event.getExecutionId(), event.getProcessInstanceId(), ((FlowableExceptionEvent)event).getCause()});
        }
        ProcessError result = ProcessError.builder().processId(event.getProcessInstanceId()).executionId(event.getExecutionId()).message(this.exceptionMessage(event)).build();
        this.applicationEventPublisher.publishEvent((Object)result);
    }

    private String exceptionMessage(FlowableEngineEntityEvent event) {
        if (event instanceof FlowableExceptionEvent) {
            return "An exception occurred";
        }
        return "An error occurred";
    }
}

