/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.bpmnshared.config.flowable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import de.adorsys.opba.protocol.api.services.scoped.RequestScopedServicesProvider;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.FlowableJobEventListener;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.FlowableObjectMapper;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.FlowableProperties;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.JacksonMixin;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.JsonCustomSerializer;
import de.adorsys.opba.protocol.bpmnshared.config.flowable.LargeJsonCustomSerializer;
import java.util.ArrayList;
import java.util.List;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FlowableConfig {
    @Bean
    EngineConfigurationConfigurer<SpringProcessEngineConfiguration> productionCustomizeListenerAndJsonSerializer(RequestScopedServicesProvider scopedServicesProvider, FlowableProperties flowableProperties, FlowableObjectMapper mapper, FlowableJobEventListener eventListener) {
        int maxLength = flowableProperties.getSerialization().getMaxLength();
        List<String> serializeOnlyPackages = flowableProperties.getSerialization().getSerializeOnlyPackages();
        return processConfiguration -> {
            processConfiguration.setCustomPreVariableTypes(new ArrayList(ImmutableList.of((Object)new JsonCustomSerializer(scopedServicesProvider, mapper.getMapper(), serializeOnlyPackages, maxLength), (Object)((Object)new LargeJsonCustomSerializer(scopedServicesProvider, mapper.getMapper(), serializeOnlyPackages, maxLength)))));
            processConfiguration.setEnableEventDispatcher(true);
            processConfiguration.setEventListeners((List)ImmutableList.of((Object)((Object)eventListener)));
            processConfiguration.setAsyncExecutorNumberOfRetries(flowableProperties.getNumberOfRetries());
        };
    }

    @Bean
    FlowableObjectMapper mapper(List<? extends JacksonMixin> mixins) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mixins.forEach(it -> mapper.addMixIn(it.getType(), it.getMixin()));
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.ANY));
        return new FlowableObjectMapper(mapper);
    }
}

