/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.restapi.shared.service;

import de.adorsys.opba.protocol.facade.dto.result.torest.FacadeResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeResultRedirectable;
import de.adorsys.opba.restapi.shared.mapper.FacadeResponseBodyToRestBodyMapper;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RedirectionOnlyToOkMapper {
    public <T, F> ResponseEntity<?> translate(FacadeResult<F> result, FacadeResponseBodyToRestBodyMapper<T, F> mapper) {
        if (result instanceof FacadeResultRedirectable) {
            return this.handleRedirect((FacadeResultRedirectable)result, mapper);
        }
        throw new IllegalArgumentException("Unknown result type: " + result.getClass());
    }

    protected <T, F> ResponseEntity<?> handleRedirect(FacadeResultRedirectable<F, ?> result, FacadeResponseBodyToRestBodyMapper<T, F> mapper) {
        ResponseEntity.BodyBuilder response = this.putDefaultHeaders((FacadeResult<?>)result, ResponseEntity.status((HttpStatus)HttpStatus.OK));
        this.putExtraRedirectHeaders(result, response);
        T body = mapper.map(result.getCause());
        return this.responseForRedirection(result, response).body(body);
    }

    protected ResponseEntity.BodyBuilder responseForRedirection(FacadeResultRedirectable<?, ?> result, ResponseEntity.BodyBuilder response) {
        ((ResponseEntity.BodyBuilder)response.header("Authorization-Session-ID", new String[]{result.getAuthorizationSessionId()})).header("X-XSRF-TOKEN", new String[]{result.getRedirectCode()});
        if (null != result.getRedirectionTo()) {
            response.header("Location", new String[]{result.getRedirectionTo().toASCIIString()});
        }
        return response;
    }

    protected ResponseEntity.BodyBuilder putDefaultHeaders(FacadeResult<?> result, ResponseEntity.BodyBuilder builder) {
        ((ResponseEntity.BodyBuilder)builder.header("X-Request-ID", new String[]{null == result.getXRequestId() ? null : result.getXRequestId().toString()})).header("Service-Session-ID", new String[]{result.getServiceSessionId()});
        return builder;
    }

    protected ResponseEntity.BodyBuilder putExtraRedirectHeaders(FacadeResultRedirectable<?, ?> result, ResponseEntity.BodyBuilder builder) {
        result.getHeaders().forEach((x$0, xva$1) -> {
            ResponseEntity.BodyBuilder cfr_ignored_0 = (ResponseEntity.BodyBuilder)builder.header(x$0, new String[]{xva$1});
        });
        return builder;
    }
}

