/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.restapi.shared.service;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.adorsys.opba.api.security.internal.config.CookieProperties;
import de.adorsys.opba.api.security.internal.service.CookieBuilderTemplate;
import de.adorsys.opba.protocol.facade.dto.result.torest.FacadeResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeRedirectErrorResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeResultRedirectable;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeRuntimeErrorResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeRuntimeErrorResultWithOwnResponseCode;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeStartAuthorizationResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.staticres.FacadeSuccessResult;
import de.adorsys.opba.restapi.shared.mapper.FacadeResponseBodyToRestBodyMapper;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class FacadeResponseMapper {
    private final CookieProperties cookieProperties;
    private final CookieBuilderTemplate cookieBuilderTemplate;

    public <T, F> ResponseEntity<?> translate(FacadeResult<F> result, FacadeResponseBodyToRestBodyMapper<T, F> mapper) {
        if (result instanceof FacadeRedirectErrorResult) {
            return this.handleError((FacadeRedirectErrorResult)result);
        }
        if (result instanceof FacadeRuntimeErrorResultWithOwnResponseCode) {
            return this.handleErrorWithOwnResponseCode((FacadeRuntimeErrorResultWithOwnResponseCode)result);
        }
        if (result instanceof FacadeRuntimeErrorResult) {
            return this.handleError((FacadeRuntimeErrorResult)result);
        }
        if (result instanceof FacadeResultRedirectable) {
            return this.handleRedirect((FacadeResultRedirectable)result);
        }
        if (result instanceof FacadeSuccessResult) {
            return this.handleSuccess((FacadeSuccessResult)result, mapper);
        }
        throw new IllegalArgumentException("Unknown result type: " + result.getClass());
    }

    protected ResponseEntity<?> handleRedirect(FacadeResultRedirectable<?, ?> result) {
        if (result instanceof FacadeStartAuthorizationResult) {
            return this.handleInitialAuthorizationRedirect((FacadeStartAuthorizationResult)result);
        }
        return this.doHandleRedirect(result);
    }

    protected ResponseEntity<?> handleInitialAuthorizationRedirect(FacadeStartAuthorizationResult<?, ?> result) {
        ResponseEntity.BodyBuilder response = this.putDefaultHeaders((FacadeResult<?>)result, ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED));
        this.putHeadersFromResponse((FacadeResultRedirectable<?, ?>)result, response);
        response.body((Object)result.getCause());
        return this.responseForRedirection((FacadeResultRedirectable<?, ?>)result, response);
    }

    protected ResponseEntity<?> doHandleRedirect(FacadeResultRedirectable<?, ?> result) {
        ResponseEntity.BodyBuilder response = this.putDefaultHeaders((FacadeResult<?>)result, ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED));
        this.putHeadersFromResponse(result, response);
        response.body((Object)result.getCause());
        return this.responseForRedirection(result, response);
    }

    protected ResponseEntity<Map<String, String>> responseForRedirection(FacadeResultRedirectable<?, ?> result, ResponseEntity.BodyBuilder response) {
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)this.setCookieHeaders(result, response).header("Authorization-Session-ID", new String[]{result.getAuthorizationSessionId()})).header("Redirect-Code", new String[]{result.getRedirectCode()})).header("X-XSRF-TOKEN", new String[]{result.getRedirectCode()})).header("PSU-Consent-Session", new String[]{"BAR"})).location(result.getRedirectionTo())).body((Object)ImmutableMap.of((Object)"msg", (Object)"Please use redirect link in 'Location' header"));
    }

    protected <E> ResponseEntity<E> handleError(FacadeRedirectErrorResult<?, ?> result) {
        ResponseEntity.BodyBuilder response = this.putDefaultHeaders((FacadeResult<?>)result, ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED));
        return this.putHeadersFromResponse((FacadeResultRedirectable<?, ?>)result, response).build();
    }

    protected <E> ResponseEntity<E> handleError(FacadeRuntimeErrorResult<?> result) {
        ResponseEntity.BodyBuilder response = this.putDefaultHeaders((FacadeResult<?>)result, ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
        return this.putHeadersFromResponse(result, response).build();
    }

    protected <E> ResponseEntity<E> handleErrorWithOwnResponseCode(FacadeRuntimeErrorResultWithOwnResponseCode<?> result) {
        ResponseEntity.BodyBuilder response = this.putDefaultHeaders((FacadeResult<?>)result, ResponseEntity.status((int)result.getResponseCode()));
        return this.putHeadersFromResponse((FacadeRuntimeErrorResult<?>)result, response).build();
    }

    protected <T, F> ResponseEntity<T> handleSuccess(FacadeSuccessResult<F> result, FacadeResponseBodyToRestBodyMapper<T, F> mapper) {
        ResponseEntity.BodyBuilder response = this.putDefaultHeaders((FacadeResult<?>)result, ResponseEntity.status((HttpStatus)HttpStatus.OK));
        return response.body(mapper.map(result.getBody()));
    }

    protected ResponseEntity.BodyBuilder putDefaultHeaders(FacadeResult<?> result, ResponseEntity.BodyBuilder builder) {
        ((ResponseEntity.BodyBuilder)builder.header("X-Request-ID", new String[]{null == result.getXRequestId() ? null : result.getXRequestId().toString()})).header("Service-Session-ID", new String[]{result.getServiceSessionId()});
        return builder;
    }

    protected ResponseEntity.BodyBuilder putHeadersFromResponse(FacadeRuntimeErrorResult<?> result, ResponseEntity.BodyBuilder builder) {
        result.getHeaders().forEach((x$0, xva$1) -> {
            ResponseEntity.BodyBuilder cfr_ignored_0 = (ResponseEntity.BodyBuilder)builder.header(x$0, new String[]{xva$1});
        });
        return builder;
    }

    protected ResponseEntity.BodyBuilder putHeadersFromResponse(FacadeResultRedirectable<?, ?> result, ResponseEntity.BodyBuilder builder) {
        result.getHeaders().forEach((x$0, xva$1) -> {
            ResponseEntity.BodyBuilder cfr_ignored_0 = (ResponseEntity.BodyBuilder)builder.header(x$0, new String[]{xva$1});
        });
        return builder;
    }

    private ResponseEntity.BodyBuilder setCookieHeaders(FacadeResultRedirectable<?, ?> result, ResponseEntity.BodyBuilder builder) {
        if (Strings.isNullOrEmpty((String)result.getToken())) {
            return builder;
        }
        String redirectPath = this.fromAspspRedirectPath(result.getAuthorizationSessionId(), result.getRedirectCode());
        ResponseCookie responseCookie = this.cookieBuilderTemplate.builder(result.getToken(), redirectPath, this.cookieProperties.getRedirectMaxAge()).build();
        ((ResponseEntity.BodyBuilder)builder.header("Cookie-TTL", new String[]{Long.toString(this.cookieProperties.getRedirectMaxAge().getSeconds())})).header("Set-Cookie", new String[]{responseCookie.toString()});
        return builder;
    }

    public String fromAspspRedirectPath(String authorizationId, String redirectState) {
        return UriComponentsBuilder.fromPath((String)this.cookieProperties.getRedirectPathTemplate()).buildAndExpand((Map)ImmutableMap.of((Object)"authorizationSessionId", (Object)authorizationId, (Object)"redirectState", (Object)redirectState)).toUriString();
    }

    @ConstructorProperties(value={"cookieProperties", "cookieBuilderTemplate"})
    @Generated
    public FacadeResponseMapper(CookieProperties cookieProperties, CookieBuilderTemplate cookieBuilderTemplate) {
        this.cookieProperties = cookieProperties;
        this.cookieBuilderTemplate = cookieBuilderTemplate;
    }
}

