package de.adorsys.opba.db.domain.entity;

import de.adorsys.opba.db.domain.entity.BankProfile.ToBankProfileDescriptor;
import de.adorsys.opba.db.domain.entity.BankProfile.ToConsentSupported;
import de.adorsys.opba.db.domain.entity.helpers.UuidMapper;
import de.adorsys.opba.tppbankingapi.search.model.generated.BankProfileDescriptor;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-10-11T15:47:02+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
public class BankProfile$ToBankProfileDescriptorImpl implements ToBankProfileDescriptor {

    private final ToConsentSupported toConsentSupported = Mappers.getMapper( ToConsentSupported.class );
    private final UuidMapper uuidMapper = Mappers.getMapper( UuidMapper.class );

    @Override
    public BankProfileDescriptor map(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        BankProfileDescriptor bankProfileDescriptor = new BankProfileDescriptor();

        bankProfileDescriptor.setBankName( bankProfileBankName( bankProfile ) );
        bankProfileDescriptor.setBic( bankProfileBankBic( bankProfile ) );
        bankProfileDescriptor.setBankUuid( uuidMapper.map( bankProfileBankUuid( bankProfile ) ) );
        bankProfileDescriptor.setConsentSupportByService( toConsentSupported.map( bankProfile.getActions() ) );
        bankProfileDescriptor.setIsSandbox( bankProfile.isSandbox() );
        bankProfileDescriptor.setIsActive( bankProfile.isActive() );
        bankProfileDescriptor.setName( bankProfile.getName() );
        bankProfileDescriptor.setUuid( bankProfile.getUuid() );
        bankProfileDescriptor.setExternalId( bankProfile.getExternalId() );
        bankProfileDescriptor.setExternalInterfaces( bankProfile.getExternalInterfaces() );
        bankProfileDescriptor.setProtocolType( bankProfile.getProtocolType() );

        bankProfileDescriptor.setServiceList( bankProfile.getActions().keySet().stream().map(Enum::name).collect(java.util.stream.Collectors.toList()) );

        return bankProfileDescriptor;
    }

    private String bankProfileBankName(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String name = bank.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private String bankProfileBankBic(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String bic = bank.getBic();
        if ( bic == null ) {
            return null;
        }
        return bic;
    }

    private UUID bankProfileBankUuid(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        UUID uuid = bank.getUuid();
        if ( uuid == null ) {
            return null;
        }
        return uuid;
    }
}
