package de.adorsys.opba.db.domain.entity;

import de.adorsys.opba.db.domain.entity.BankProfile.ToAspsp;
import de.adorsys.opba.db.domain.entity.helpers.UuidMapper;
import de.adorsys.xs2a.adapter.api.model.Aspsp;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-10-11T15:47:02+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
public class BankProfile$ToAspspImpl implements ToAspsp {

    private final UuidMapper uuidMapper = Mappers.getMapper( UuidMapper.class );

    @Override
    public Aspsp map(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        Aspsp aspsp = new Aspsp();

        aspsp.setName( bankProfileBankName( bankProfile ) );
        aspsp.setBic( bankProfileBankBic( bankProfile ) );
        aspsp.setBankCode( uuidMapper.map( bankProfileBankUuid( bankProfile ) ) );
        if ( bankProfile.getId() != null ) {
            aspsp.setId( String.valueOf( bankProfile.getId() ) );
        }
        aspsp.setUrl( bankProfile.getUrl() );
        aspsp.setAdapterId( bankProfile.getAdapterId() );
        aspsp.setIdpUrl( bankProfile.getIdpUrl() );

        aspsp.setScaApproaches( bankProfile.getScaApproaches().stream().map(a -> de.adorsys.xs2a.adapter.api.model.AspspScaApproach.valueOf(a.name())).collect(java.util.stream.Collectors.toList()) );

        return aspsp;
    }

    private String bankProfileBankName(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String name = bank.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private String bankProfileBankBic(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String bic = bank.getBic();
        if ( bic == null ) {
            return null;
        }
        return bic;
    }

    private UUID bankProfileBankUuid(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        UUID uuid = bank.getUuid();
        if ( uuid == null ) {
            return null;
        }
        return uuid;
    }
}
