package de.adorsys.opba.db.domain.entity;

import de.adorsys.opba.db.domain.entity.BankProfile.ToBankProfileDescriptor;
import de.adorsys.opba.db.domain.entity.BankProfile.ToConsentSupported;
import de.adorsys.opba.tppbankingapi.search.model.generated.BankProfileDescriptor;
import javax.annotation.processing.Generated;
import org.mapstruct.factory.Mappers;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-11-17T19:01:52+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.9 (Azul Systems, Inc.)"
)
public class BankProfile$ToBankProfileDescriptorImpl implements ToBankProfileDescriptor {

    private final ToConsentSupported toConsentSupported = Mappers.getMapper( ToConsentSupported.class );

    @Override
    public BankProfileDescriptor map(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        BankProfileDescriptor bankProfileDescriptor = new BankProfileDescriptor();

        bankProfileDescriptor.setConsentSupportByService( toConsentSupported.map( bankProfile.getActions() ) );
        bankProfileDescriptor.setBankName( bankProfileBankName( bankProfile ) );
        bankProfileDescriptor.setBic( bankProfileBankBic( bankProfile ) );
        bankProfileDescriptor.setBankUuid( bankProfileBankUuid( bankProfile ) );

        bankProfileDescriptor.setServiceList( bankProfile.getActions().keySet().stream().map(Enum::name).collect(java.util.stream.Collectors.toList()) );

        return bankProfileDescriptor;
    }

    private String bankProfileBankName(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String name = bank.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private String bankProfileBankBic(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String bic = bank.getBic();
        if ( bic == null ) {
            return null;
        }
        return bic;
    }

    private String bankProfileBankUuid(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String uuid = bank.getUuid();
        if ( uuid == null ) {
            return null;
        }
        return uuid;
    }
}
