package de.adorsys.opba.db.domain.entity;

import de.adorsys.opba.db.domain.entity.BankProfile.ToAspsp;
import de.adorsys.xs2a.adapter.service.model.Aspsp;
import javax.annotation.processing.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-11-17T19:01:52+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.9 (Azul Systems, Inc.)"
)
public class BankProfile$ToAspspImpl implements ToAspsp {

    @Override
    public Aspsp map(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        Aspsp aspsp = new Aspsp();

        aspsp.setName( bankProfileBankName( bankProfile ) );
        aspsp.setBankCode( bankProfileBankUuid( bankProfile ) );
        aspsp.setBic( bankProfileBankBic( bankProfile ) );
        if ( bankProfile.getId() != null ) {
            aspsp.setId( String.valueOf( bankProfile.getId() ) );
        }
        aspsp.setUrl( bankProfile.getUrl() );
        aspsp.setAdapterId( bankProfile.getAdapterId() );
        aspsp.setIdpUrl( bankProfile.getIdpUrl() );

        aspsp.setScaApproaches( bankProfile.getScaApproaches().stream().map(a -> de.adorsys.xs2a.adapter.service.model.AspspScaApproach.valueOf(a.name())).collect(java.util.stream.Collectors.toList()) );

        return aspsp;
    }

    private String bankProfileBankName(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String name = bank.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private String bankProfileBankUuid(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String uuid = bank.getUuid();
        if ( uuid == null ) {
            return null;
        }
        return uuid;
    }

    private String bankProfileBankBic(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }
        Bank bank = bankProfile.getBank();
        if ( bank == null ) {
            return null;
        }
        String bic = bank.getBic();
        if ( bic == null ) {
            return null;
        }
        return bic;
    }
}
