package de.adorsys.opba.db.domain.entity;

import de.adorsys.opba.tppbankingapi.search.model.generated.BankDescriptor;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.Collection;

@Entity
@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "bank", uniqueConstraints = {@UniqueConstraint(columnNames = "uuid", name = "opb_bank_uuid_key")})
public class Bank implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final Bank.ToBankDescriptor TO_BANK_DESCRIPTOR = Mappers.getMapper(Bank.ToBankDescriptor.class);

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "bank_id_generator")
    @SequenceGenerator(name = "bank_id_generator", sequenceName = "bank_id_sequence")
    private Long id;

    String uuid;
    String name;
    String bic;
    String bankCode;

    @OneToMany(mappedBy = "aspsp", cascade = CascadeType.ALL, orphanRemoval = true)
    private Collection<Consent> consents;

    @Mapper
    public interface ToBankDescriptor {
        @Mapping(source = "name", target = "bankName")
        BankDescriptor map(Bank bank);
    }
}
