/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.token.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppbankingapi.token.model.generated.GeneralError;
import de.adorsys.opba.tppbankingapi.token.model.generated.PsuPaymentSessionResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="PaymentConfirmation", description="the PaymentConfirmation API")
public interface PaymentConfirmationApi {
    public static final Logger log = LoggerFactory.getLogger(PaymentConfirmationApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Issues new PSU Consent Session Token.", nickname="confirmPayment", notes="TBD", response=PsuPaymentSessionResponse.class, tags={"PaymentConfirmation"})
    @ApiResponses(value={@ApiResponse(code=200, message="Response containing the service profile of a bank.", response=PsuPaymentSessionResponse.class), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class), @ApiResponse(code=404, message="Resource not found or path parameter is wrong. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header")})
    @RequestMapping(value={"/v1/banking/payments/{auth-id}/confirm"}, produces={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<PsuPaymentSessionResponse> _confirmPayment(@ApiParam(value="Used to distinguish between different consent authorization processes started by the same PSU. Also included in the corresponding cookie path to limit visibility of the consent cookie to the corresponding consent process. ", required=true) @PathVariable(value="auth-id") String authId, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID) {
        return this.confirmPayment(authId, xRequestID, serviceSessionPassword, xTimestampUTC, xRequestSignature, fintechID);
    }

    default public ResponseEntity<PsuPaymentSessionResponse> confirmPayment(String authId, UUID xRequestID, String serviceSessionPassword, String xTimestampUTC, String xRequestSignature, String fintechID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((PsuPaymentSessionResponse)this.getObjectMapper().get().readValue("{\n  \"authorizationSessionId\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n}", PsuPaymentSessionResponse.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentConfirmationApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

