/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.search.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppbankingapi.search.model.generated.BankProfileResponse;
import de.adorsys.opba.tppbankingapi.search.model.generated.BankSearchResponse;
import de.adorsys.opba.tppbankingapi.search.model.generated.GeneralError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="TppBankSearch", description="the TppBankSearch API")
public interface TppBankSearchApi {
    public static final Logger log = LoggerFactory.getLogger(TppBankSearchApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Request the profile of the bank identified with id (bankId).", nickname="bankProfileGET", notes="Request the profile of the bank identified with id (bankId).", response=BankProfileResponse.class, tags={"TppBankSearch"})
    @ApiResponses(value={@ApiResponse(code=200, message="Response containing the service profile of a bank.", response=BankProfileResponse.class), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/search/bank-profile"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<BankProfileResponse> _bankProfileGET(@ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @NotNull @ApiParam(value="Identifier of the bank profile to be loaded.", required=true) @Valid @RequestParam(value="bankProfileId", required=true) UUID bankProfileId, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="Controls visibility of inactive banks in the response (false - both active and inactive, true - only active) ", defaultValue="true") @Valid @RequestParam(value="onlyActive", required=false, defaultValue="true") Boolean onlyActive) {
        return this.bankProfileGET(xRequestID, bankProfileId, xTimestampUTC, xRequestSignature, fintechID, onlyActive);
    }

    default public ResponseEntity<BankProfileResponse> bankProfileGET(UUID xRequestID, UUID bankProfileId, String xTimestampUTC, String xRequestSignature, String fintechID, Boolean onlyActive) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((BankProfileResponse)this.getObjectMapper().get().readValue("{\n  \"bankProfileDescriptor\" : {\n    \"consentSupportByService\" : {\n      \"key\" : \"consentSupportByService\"\n    },\n    \"bankUuid\" : \"bankUuid\",\n    \"name\" : \"name\",\n    \"serviceList\" : [ \"serviceList\", \"serviceList\" ],\n    \"externalInterfaces\" : \"externalInterfaces\",\n    \"externalId\" : \"externalId\",\n    \"bankName\" : \"bankName\",\n    \"protocolType\" : \"protocolType\",\n    \"isSandbox\" : true,\n    \"isActive\" : true,\n    \"bic\" : \"bic\",\n    \"uuid\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n  }\n}", BankProfileResponse.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankSearchApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Issues an incremental bank search request to the TppBankSearchApi.", nickname="bankSearchGET", notes="Issues an incremental bank search request to the TppBankSearchApi.", response=BankSearchResponse.class, tags={"TppBankSearch"})
    @ApiResponses(value={@ApiResponse(code=200, message="The result of a bank search.", response=BankSearchResponse.class), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/search/bank-search"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<BankSearchResponse> _bankSearchGET(@ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="The bank search input string") @Valid @RequestParam(value="keyword", required=false) String keyword, @ApiParam(value="The index of the first result") @Valid @RequestParam(value="start", required=false) Integer start, @ApiParam(value="The max number of entries to return with the response.") @Valid @RequestParam(value="max", required=false) Integer max, @ApiParam(value="Controls visibility of inactive banks in the response (false - both active and inactive, true - only active) ", defaultValue="true") @Valid @RequestParam(value="onlyActive", required=false, defaultValue="true") Boolean onlyActive) {
        return this.bankSearchGET(xRequestID, xTimestampUTC, xRequestSignature, fintechID, keyword, start, max, onlyActive);
    }

    default public ResponseEntity<BankSearchResponse> bankSearchGET(UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, String keyword, Integer start, Integer max, Boolean onlyActive) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((BankSearchResponse)this.getObjectMapper().get().readValue("{\n  \"total\" : 1,\n  \"bankDescriptor\" : [ {\n    \"bankCode\" : \"bankCode\",\n    \"profiles\" : [ {\n      \"consentSupportByService\" : {\n        \"key\" : \"consentSupportByService\"\n      },\n      \"bankUuid\" : \"bankUuid\",\n      \"name\" : \"name\",\n      \"serviceList\" : [ \"serviceList\", \"serviceList\" ],\n      \"externalInterfaces\" : \"externalInterfaces\",\n      \"externalId\" : \"externalId\",\n      \"bankName\" : \"bankName\",\n      \"protocolType\" : \"protocolType\",\n      \"isSandbox\" : true,\n      \"isActive\" : true,\n      \"bic\" : \"bic\",\n      \"uuid\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n    }, {\n      \"consentSupportByService\" : {\n        \"key\" : \"consentSupportByService\"\n      },\n      \"bankUuid\" : \"bankUuid\",\n      \"name\" : \"name\",\n      \"serviceList\" : [ \"serviceList\", \"serviceList\" ],\n      \"externalInterfaces\" : \"externalInterfaces\",\n      \"externalId\" : \"externalId\",\n      \"bankName\" : \"bankName\",\n      \"protocolType\" : \"protocolType\",\n      \"isSandbox\" : true,\n      \"isActive\" : true,\n      \"bic\" : \"bic\",\n      \"uuid\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n    } ],\n    \"bankName\" : \"bankName\",\n    \"isActive\" : true,\n    \"bic\" : \"bic\",\n    \"uuid\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n  }, {\n    \"bankCode\" : \"bankCode\",\n    \"profiles\" : [ {\n      \"consentSupportByService\" : {\n        \"key\" : \"consentSupportByService\"\n      },\n      \"bankUuid\" : \"bankUuid\",\n      \"name\" : \"name\",\n      \"serviceList\" : [ \"serviceList\", \"serviceList\" ],\n      \"externalInterfaces\" : \"externalInterfaces\",\n      \"externalId\" : \"externalId\",\n      \"bankName\" : \"bankName\",\n      \"protocolType\" : \"protocolType\",\n      \"isSandbox\" : true,\n      \"isActive\" : true,\n      \"bic\" : \"bic\",\n      \"uuid\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n    }, {\n      \"consentSupportByService\" : {\n        \"key\" : \"consentSupportByService\"\n      },\n      \"bankUuid\" : \"bankUuid\",\n      \"name\" : \"name\",\n      \"serviceList\" : [ \"serviceList\", \"serviceList\" ],\n      \"externalInterfaces\" : \"externalInterfaces\",\n      \"externalId\" : \"externalId\",\n      \"bankName\" : \"bankName\",\n      \"protocolType\" : \"protocolType\",\n      \"isSandbox\" : true,\n      \"isActive\" : true,\n      \"bic\" : \"bic\",\n      \"uuid\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n    } ],\n    \"bankName\" : \"bankName\",\n    \"isActive\" : true,\n    \"bic\" : \"bic\",\n    \"uuid\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\"\n  } ],\n  \"max\" : 6,\n  \"start\" : 0,\n  \"keyword\" : \"\"\n}", BankSearchResponse.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankSearchApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

