/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.pis.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentInitiation;
import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentInitiationResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="TppBankingApiSinglePaymentPis", description="the TppBankingApiSinglePaymentPis API")
public interface TppBankingApiSinglePaymentPisApi {
    public static final Logger log = LoggerFactory.getLogger(TppBankingApiSinglePaymentPisApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Payment initiation request", nickname="initiatePayment", notes="This method is used to initiate a payment at the ASPSP.", response=PaymentInitiationResponse.class, tags={"TPP Banking API Single Payment (PIS)"})
    @ApiResponses(value={@ApiResponse(code=202, message="ACCEPTED", response=PaymentInitiationResponse.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankProfileID", value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xPsuAuthenticationRequired", value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="fintechUserID", value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLOK", value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLNOK", value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="computePSUIPAddress", value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="psUIPAddress", value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ", dataType="String", paramType="header")})
    @RequestMapping(value={"/v1/banking/pis/payments/{payment-product}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public CompletableFuture<ResponseEntity<PaymentInitiationResponse>> _initiatePayment(@ApiParam(value="", required=true) @Valid @RequestBody PaymentInitiation body, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID, @ApiParam(value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK, @ApiParam(value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="", required=true, allowableValues="sepa-credit-transfers, instant-sepa-credit-transfers, target-2-payments, cross-border-credit-transfers, pain.001-sepa-credit-transfers, pain.001-instant-sepa-credit-transfers, pain.001-target-2-payments, pain.001-cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-Profile-ID", required=false) UUID bankProfileID, @ApiParam(value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", defaultValue="true") @RequestHeader(value="X-Psu-Authentication-Required", required=false) Boolean xPsuAuthenticationRequired, @ApiParam(value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ") @RequestHeader(value="Compute-PSU-IP-Address", required=false) Boolean computePSUIPAddress, @ApiParam(value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress) {
        return this.initiatePayment(body, serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, paymentProduct, xTimestampUTC, xRequestSignature, fintechID, bankProfileID, xPsuAuthenticationRequired, computePSUIPAddress, psUIPAddress);
    }

    default public CompletableFuture<ResponseEntity<PaymentInitiationResponse>> initiatePayment(PaymentInitiation body, String serviceSessionPassword, String fintechUserID, String fintechRedirectURLOK, String fintechRedirectURLNOK, UUID xRequestID, String paymentProduct, String xTimestampUTC, String xRequestSignature, String fintechID, UUID bankProfileID, Boolean xPsuAuthenticationRequired, Boolean computePSUIPAddress, String psUIPAddress) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((PaymentInitiationResponse)this.getObjectMapper().get().readValue("{\n  \"msg\" : \"msg\"\n}", PaymentInitiationResponse.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiSinglePaymentPisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }
}

