/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.pis.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppbankingapi.pis.model.generated.GeneralError;
import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentInformationResponse;
import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentStatusResponse;
import de.adorsys.opba.tppbankingapi.pis.model.generated.SessionStatusDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="TppBankingApiPaymentStatusPis", description="the TppBankingApiPaymentStatusPis API")
public interface TppBankingApiPaymentStatusPisApi {
    public static final Logger log = LoggerFactory.getLogger(TppBankingApiPaymentStatusPisApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Get payment information", nickname="getPaymentInformation", notes="Returns the content of a payment object", response=PaymentInformationResponse.class, tags={"TPP Banking API Payment Status (PIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PaymentInformationResponse.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankProfileID", value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/pis/payments/{payment-product}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<PaymentInformationResponse>> _getPaymentInformation(@ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="", required=true, allowableValues="sepa-credit-transfers, instant-sepa-credit-transfers, target-2-payments, cross-border-credit-transfers, pain.001-sepa-credit-transfers, pain.001-instant-sepa-credit-transfers, pain.001-target-2-payments, pain.001-cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-Profile-ID", required=false) UUID bankProfileID, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID) {
        return this.getPaymentInformation(serviceSessionPassword, xRequestID, paymentProduct, xTimestampUTC, xRequestSignature, fintechID, bankProfileID, serviceSessionID);
    }

    default public CompletableFuture<ResponseEntity<PaymentInformationResponse>> getPaymentInformation(String serviceSessionPassword, UUID xRequestID, String paymentProduct, String xTimestampUTC, String xRequestSignature, String fintechID, UUID bankProfileID, UUID serviceSessionID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((PaymentInformationResponse)this.getObjectMapper().get().readValue("{\n  \"debtorAccount\" : {\n    \"bban\" : \"BARC12345612345678\",\n    \"externalResourceId\" : \"externalResourceId\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"currency\" : \"EUR\",\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\"\n  },\n  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"creditorAddress\" : {\n    \"street\" : \"rue blue\",\n    \"buildingnNumber\" : \"89\",\n    \"city\" : \"Paris\",\n    \"postalCode\" : \"75000\",\n    \"country\" : \"FR\"\n  },\n  \"externalResourceId\" : \"externalResourceId\",\n  \"creditorName\" : \"Creditor Name\",\n  \"creditorAgent\" : \"AAAADEBBXXX\",\n  \"transactionStatus\" : \"transactionStatus\",\n  \"instructedAmount\" : {\n    \"currency\" : \"EUR\",\n    \"amount\" : \"123\"\n  },\n  \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n  \"endToEndIdentification\" : \"endToEndIdentification\"\n}", PaymentInformationResponse.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiPaymentStatusPisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Payment initiation status request", nickname="getPaymentStatus", notes="Check the transaction status of a payment initiation.", response=PaymentStatusResponse.class, tags={"TPP Banking API Payment Status (PIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PaymentStatusResponse.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankProfileID", value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/pis/payments/{payment-product}/status"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<PaymentStatusResponse>> _getPaymentStatus(@ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="", required=true, allowableValues="sepa-credit-transfers, instant-sepa-credit-transfers, target-2-payments, cross-border-credit-transfers, pain.001-sepa-credit-transfers, pain.001-instant-sepa-credit-transfers, pain.001-target-2-payments, pain.001-cross-border-credit-transfers") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-Profile-ID", required=false) UUID bankProfileID, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID) {
        return this.getPaymentStatus(serviceSessionPassword, xRequestID, paymentProduct, xTimestampUTC, xRequestSignature, fintechID, bankProfileID, serviceSessionID);
    }

    default public CompletableFuture<ResponseEntity<PaymentStatusResponse>> getPaymentStatus(String serviceSessionPassword, UUID xRequestID, String paymentProduct, String xTimestampUTC, String xRequestSignature, String fintechID, UUID bankProfileID, UUID serviceSessionID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((PaymentStatusResponse)this.getObjectMapper().get().readValue("{\n  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"externalResourceId\" : \"externalResourceId\",\n  \"transactionStatus\" : \"transactionStatus\",\n  \"fundsAvailable\" : true,\n  \"psuMessage\" : \"psuMessage\"\n}", PaymentStatusResponse.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiPaymentStatusPisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Get service session (payment) authorization status.", nickname="getPisSessionStatus", notes="Reads session status adding external status providers if necessary. Is used to understand current state of the entire payment (session) - completed,not started,error,etc. in addition to webhooks.", response=SessionStatusDetails.class, tags={"TPP Banking API Payment Status (PIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="Session status - describe service session (consent/payment) readiness. ", response=SessionStatusDetails.class), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/pis/{Service-Session-ID}/status"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<SessionStatusDetails>> _getPisSessionStatus(@ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", required=true) @PathVariable(value="Service-Session-ID") UUID serviceSessionID, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID) {
        return this.getPisSessionStatus(serviceSessionID, serviceSessionPassword, xRequestID, xTimestampUTC, xRequestSignature, fintechID);
    }

    default public CompletableFuture<ResponseEntity<SessionStatusDetails>> getPisSessionStatus(UUID serviceSessionID, String serviceSessionPassword, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((SessionStatusDetails)this.getObjectMapper().get().readValue("{\n  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"detailedStatus\" : {\n    \"key\" : {\n      \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"lastErrorRequestId\" : \"lastErrorRequestId\",\n      \"externalStatus\" : \"externalStatus\",\n      \"lastRequestId\" : \"lastRequestId\",\n      \"updatedAt\" : \"2000-01-23T04:56:07.000+00:00\"\n    }\n  },\n  \"externalStatus\" : \"externalStatus\",\n  \"updatedAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"status\" : \"PENDING\"\n}", SessionStatusDetails.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiPaymentStatusPisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }
}

