/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.pis.model.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.opba.tppbankingapi.pis.model.generated.AuthSessionStatus;
import de.adorsys.opba.tppbankingapi.pis.model.generated.SessionStatus;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@Validated
public class SessionStatusDetails {
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="updatedAt")
    private OffsetDateTime updatedAt = null;
    @JsonProperty(value="status")
    private SessionStatus status = null;
    @JsonProperty(value="externalStatus")
    private String externalStatus = null;
    @JsonProperty(value="detailedStatus")
    @Valid
    private Map<String, AuthSessionStatus> detailedStatus = null;

    public SessionStatusDetails createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="Creation time of service session")
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public SessionStatusDetails updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="Update time of service session")
    @Valid
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public SessionStatusDetails status(SessionStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public SessionStatus getStatus() {
        return this.status;
    }

    public void setStatus(SessionStatus status) {
        this.status = status;
    }

    public SessionStatusDetails externalStatus(String externalStatus) {
        this.externalStatus = externalStatus;
        return this;
    }

    @ApiModelProperty(value="External status (i.e. in 3rd party service)")
    public String getExternalStatus() {
        return this.externalStatus;
    }

    public void setExternalStatus(String externalStatus) {
        this.externalStatus = externalStatus;
    }

    public SessionStatusDetails detailedStatus(Map<String, AuthSessionStatus> detailedStatus) {
        this.detailedStatus = detailedStatus;
        return this;
    }

    public SessionStatusDetails putDetailedStatusItem(String key, AuthSessionStatus detailedStatusItem) {
        if (this.detailedStatus == null) {
            this.detailedStatus = new HashMap<String, AuthSessionStatus>();
        }
        this.detailedStatus.put(key, detailedStatusItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Map<String, AuthSessionStatus> getDetailedStatus() {
        return this.detailedStatus;
    }

    public void setDetailedStatus(Map<String, AuthSessionStatus> detailedStatus) {
        this.detailedStatus = detailedStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionStatusDetails sessionStatusDetails = (SessionStatusDetails)o;
        return Objects.equals(this.createdAt, sessionStatusDetails.createdAt) && Objects.equals(this.updatedAt, sessionStatusDetails.updatedAt) && Objects.equals((Object)this.status, (Object)sessionStatusDetails.status) && Objects.equals(this.externalStatus, sessionStatusDetails.externalStatus) && Objects.equals(this.detailedStatus, sessionStatusDetails.detailedStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.updatedAt, this.status, this.externalStatus, this.detailedStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionStatusDetails {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    externalStatus: ").append(this.toIndentedString(this.externalStatus)).append("\n");
        sb.append("    detailedStatus: ").append(this.toIndentedString(this.detailedStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

