/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.ais.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppbankingapi.ais.model.generated.AccountList;
import de.adorsys.opba.tppbankingapi.ais.model.generated.GeneralError;
import de.adorsys.opba.tppbankingapi.ais.model.generated.SessionStatusDetails;
import de.adorsys.opba.tppbankingapi.ais.model.generated.TransactionsResponse;
import de.adorsys.opba.tppbankingapi.ais.model.generated.UpdateAisExternalSessionStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="TppBankingApiAccountInformationServiceAis", description="the TppBankingApiAccountInformationServiceAis API")
public interface TppBankingApiAccountInformationServiceAisApi {
    public static final Logger log = LoggerFactory.getLogger(TppBankingApiAccountInformationServiceAisApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Deletes consent associated with service session.", nickname="deleteConsent", notes="Deletes consent(s) that is associated with service session, deletes them in ASPSP, deletes data that is associated with the consent.", tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/consents/{Service-Session-ID}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public CompletableFuture<ResponseEntity<Void>> _deleteConsent(@ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", required=true) @PathVariable(value="Service-Session-ID") UUID serviceSessionID, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="Delete FinAPI user when deleting consent. ", defaultValue="false") @Valid @RequestParam(value="deleteAll", required=false, defaultValue="false") Boolean deleteAll) {
        return this.deleteConsent(serviceSessionID, serviceSessionPassword, xRequestID, xTimestampUTC, xRequestSignature, fintechID, deleteAll);
    }

    default public CompletableFuture<ResponseEntity<Void>> deleteConsent(UUID serviceSessionID, String serviceSessionPassword, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, Boolean deleteAll) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Provides list of available accounts", nickname="getAccounts", notes="Read the identifiers of the available payment accounts. It is assumed that a consent of the PSU to this access is already given and stored on the TPP system. The addressed list of accounts depends then on the PSU and Consent information, stored respectively the OAuth2 access token. Returns all identifiers of the accounts, to which an account access has been granted to by the PSU. In addition, relevant information about the accounts and hyperlinks to corresponding account information resources are provided if a related consent has been already granted.", response=AccountList.class, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AccountList.class), @ApiResponse(code=202, message="User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response using 'Location' header. This is soft redirection, so that FinTech should inform user about redirection. "), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class), @ApiResponse(code=410, message="The headerfield tells what exactly was wrong. "), @ApiResponse(code=429, message="The headerfield tells what exactly was wrong. ")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankProfileID", value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xPsuAuthenticationRequired", value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="fintechUserID", value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLOK", value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLNOK", value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="xCreateConsentIfNone", value="", dataType="String", paramType="header"), @ApiImplicitParam(name="xImportUserData", value="Optional, third party data like username/password of external service to be used in service session. Allows to import already existing users into this system.", dataType="String", paramType="header"), @ApiImplicitParam(name="computePSUIPAddress", value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="psUIPAddress", value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ", dataType="String", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/accounts"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<AccountList>> _getAccounts(@ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID, @ApiParam(value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK, @ApiParam(value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-Profile-ID", required=false) UUID bankProfileID, @ApiParam(value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", defaultValue="true") @RequestHeader(value="X-Psu-Authentication-Required", required=false) Boolean xPsuAuthenticationRequired, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID, @ApiParam(value="") @RequestHeader(value="X-Create-Consent-If-None", required=false) String xCreateConsentIfNone, @ApiParam(value="Optional, third party data like username/password of external service to be used in service session. Allows to import already existing users into this system.") @RequestHeader(value="X-Import-User-Data", required=false) String xImportUserData, @ApiParam(value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ") @RequestHeader(value="Compute-PSU-IP-Address", required=false) Boolean computePSUIPAddress, @ApiParam(value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="For list of accounts this query param defines to not only look for the accounts, but for the balances too. ") @Valid @RequestParam(value="withBalance", required=false) Boolean withBalance, @ApiParam(value="Makes possible to request actual data and update cache if cache is used by protocol implementation. ", defaultValue="true") @Valid @RequestParam(value="online", required=false, defaultValue="true") Boolean online) {
        return this.getAccounts(serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, xTimestampUTC, xRequestSignature, fintechID, bankProfileID, xPsuAuthenticationRequired, serviceSessionID, xCreateConsentIfNone, xImportUserData, computePSUIPAddress, psUIPAddress, withBalance, online);
    }

    default public CompletableFuture<ResponseEntity<AccountList>> getAccounts(String serviceSessionPassword, String fintechUserID, String fintechRedirectURLOK, String fintechRedirectURLNOK, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, UUID bankProfileID, Boolean xPsuAuthenticationRequired, UUID serviceSessionID, String xCreateConsentIfNone, String xImportUserData, Boolean computePSUIPAddress, String psUIPAddress, Boolean withBalance, Boolean online) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((AccountList)this.getObjectMapper().get().readValue("{\n  \"accounts\" : [ {\n    \"cashAccountType\" : \"cashAccountType\",\n    \"resourceId\" : \"resourceId\",\n    \"product\" : \"product\",\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"externalResourceId\" : \"externalResourceId\",\n    \"_links\" : {\n      \"balances\" : {\n        \"href\" : \"https://www.example.com/path/resource?parameter=value\"\n      }\n    },\n    \"usage\" : \"PRIV\",\n    \"balances\" : [ {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    }, {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    } ],\n    \"ownerName\" : \"ownerName\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"name\" : \"name\",\n    \"linkedAccounts\" : \"linkedAccounts\",\n    \"currency\" : \"EUR\",\n    \"details\" : \"details\",\n    \"ownerAddress\" : {\n      \"street\" : \"rue blue\",\n      \"buildingnNumber\" : \"89\",\n      \"city\" : \"Paris\",\n      \"postalCode\" : \"75000\",\n      \"country\" : \"FR\"\n    },\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\",\n    \"bic\" : \"AAAADEBBXXX\",\n    \"status\" : \"enabled\"\n  }, {\n    \"cashAccountType\" : \"cashAccountType\",\n    \"resourceId\" : \"resourceId\",\n    \"product\" : \"product\",\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"externalResourceId\" : \"externalResourceId\",\n    \"_links\" : {\n      \"balances\" : {\n        \"href\" : \"https://www.example.com/path/resource?parameter=value\"\n      }\n    },\n    \"usage\" : \"PRIV\",\n    \"balances\" : [ {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    }, {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    } ],\n    \"ownerName\" : \"ownerName\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"name\" : \"name\",\n    \"linkedAccounts\" : \"linkedAccounts\",\n    \"currency\" : \"EUR\",\n    \"details\" : \"details\",\n    \"ownerAddress\" : {\n      \"street\" : \"rue blue\",\n      \"buildingnNumber\" : \"89\",\n      \"city\" : \"Paris\",\n      \"postalCode\" : \"75000\",\n      \"country\" : \"FR\"\n    },\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\",\n    \"bic\" : \"AAAADEBBXXX\",\n    \"status\" : \"enabled\"\n  } ]\n}", AccountList.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Get service session authorization status.", nickname="getAisSessionStatus", notes="Reads session status adding external status providers if necessary. Is used to understand current state of the consent (session) - completed,not started,error,etc. in addition to webhooks.", response=SessionStatusDetails.class, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="Session status - describe service session (consent/payment) readiness. ", response=SessionStatusDetails.class), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/{Service-Session-ID}/status"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<SessionStatusDetails>> _getAisSessionStatus(@ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", required=true) @PathVariable(value="Service-Session-ID") UUID serviceSessionID, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID) {
        return this.getAisSessionStatus(serviceSessionID, serviceSessionPassword, xRequestID, xTimestampUTC, xRequestSignature, fintechID);
    }

    default public CompletableFuture<ResponseEntity<SessionStatusDetails>> getAisSessionStatus(UUID serviceSessionID, String serviceSessionPassword, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((SessionStatusDetails)this.getObjectMapper().get().readValue("{\n  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"detailedStatus\" : {\n    \"key\" : {\n      \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"lastErrorRequestId\" : \"lastErrorRequestId\",\n      \"externalStatus\" : \"externalStatus\",\n      \"lastRequestId\" : \"lastRequestId\",\n      \"updatedAt\" : \"2000-01-23T04:56:07.000+00:00\"\n    }\n  },\n  \"externalStatus\" : \"externalStatus\",\n  \"updatedAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"status\" : \"PENDING\"\n}", SessionStatusDetails.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Provides list of transactions by given account", nickname="getTransactions", notes="returns list of transactions for specified account resource ID in case Service-Session-ID is provided and saved consent on tpp by it found. Otherwise initiates creation of new consent", response=TransactionsResponse.class, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TransactionsResponse.class), @ApiResponse(code=202, message="User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response using 'Location' header. This is soft redirection, so that FinTech should inform user about redirection. "), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankProfileID", value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xPsuAuthenticationRequired", value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="fintechUserID", value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLOK", value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLNOK", value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="xCreateConsentIfNone", value="", dataType="String", paramType="header"), @ApiImplicitParam(name="xImportUserData", value="Optional, third party data like username/password of external service to be used in service session. Allows to import already existing users into this system.", dataType="String", paramType="header"), @ApiImplicitParam(name="computePSUIPAddress", value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="psUIPAddress", value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ", dataType="String", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/accounts/{account-id}/transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<TransactionsResponse>> _getTransactions(@ApiParam(value="", required=true) @PathVariable(value="account-id") String accountId, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID, @ApiParam(value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK, @ApiParam(value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-Profile-ID", required=false) UUID bankProfileID, @ApiParam(value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", defaultValue="true") @RequestHeader(value="X-Psu-Authentication-Required", required=false) Boolean xPsuAuthenticationRequired, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID, @ApiParam(value="") @RequestHeader(value="X-Create-Consent-If-None", required=false) String xCreateConsentIfNone, @ApiParam(value="Optional, third party data like username/password of external service to be used in service session. Allows to import already existing users into this system.") @RequestHeader(value="X-Import-User-Data", required=false) String xImportUserData, @ApiParam(value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ") @RequestHeader(value="Compute-PSU-IP-Address", required=false) Boolean computePSUIPAddress, @ApiParam(value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="Conditional: Starting date (inclusive the date dateFrom) of the transaction list, mandated if no delta access is required.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateFrom", required=false) LocalDate dateFrom, @ApiParam(value="End date (inclusive the data dateTo) of the transaction list, default is \"now\" if not given.  Might be ignored if a delta function is used.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateTo", required=false) LocalDate dateTo, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the transaction with identification entryReferenceFrom alternatively to the above defined period. This is a implementation of a delta access. If this data element is contained, the entries \"dateFrom\" and \"dateTo\" might be ignored by the ASPSP if a delta report is supported.  Optional if supported by API provider. ") @Valid @RequestParam(value="entryReferenceFrom", required=false) String entryReferenceFrom, @ApiParam(value="Permitted codes are   * \"booked\",   * \"pending\" and   * \"both\" To support the \"pending\" and \"both\" feature is optional for the ASPSP, Error code if not supported in the online banking frontend Default is \"booked\" ", allowableValues="booked, pending, both") @Valid @RequestParam(value="bookingStatus", required=false) String bookingStatus, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the last report access for this PSU on the addressed account. This is another implementation of a delta access-report.  This delta indicator might be rejected by the ASPSP if this function is not supported.  Optional if supported by API provider ") @Valid @RequestParam(value="deltaList", required=false) Boolean deltaList, @ApiParam(value="Makes possible to request actual data and update cache if cache is used by protocol implementation. ", defaultValue="true") @Valid @RequestParam(value="online", required=false, defaultValue="true") Boolean online, @ApiParam(value="Analyze transactions (bookings) for categorizations. ", defaultValue="false") @Valid @RequestParam(value="analytics", required=false, defaultValue="false") Boolean analytics, @Min(value=0L) @ApiParam(value="Result page that you want to retrieve.  Minimum value is 0. ", allowableValues="") @Valid @RequestParam(value="page", required=false) @Min(value=0L) @Valid Integer page, @Min(value=1L) @Max(value=500L) @ApiParam(value="Maximum number of records per page.  Can be at most 500. ", allowableValues="") @Valid @RequestParam(value="pageSize", required=false) @Min(value=1L) @Max(value=500L) @Valid Integer pageSize) {
        return this.getTransactions(accountId, serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, xTimestampUTC, xRequestSignature, fintechID, bankProfileID, xPsuAuthenticationRequired, serviceSessionID, xCreateConsentIfNone, xImportUserData, computePSUIPAddress, psUIPAddress, dateFrom, dateTo, entryReferenceFrom, bookingStatus, deltaList, online, analytics, page, pageSize);
    }

    default public CompletableFuture<ResponseEntity<TransactionsResponse>> getTransactions(String accountId, String serviceSessionPassword, String fintechUserID, String fintechRedirectURLOK, String fintechRedirectURLNOK, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, UUID bankProfileID, Boolean xPsuAuthenticationRequired, UUID serviceSessionID, String xCreateConsentIfNone, String xImportUserData, Boolean computePSUIPAddress, String psUIPAddress, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, String bookingStatus, Boolean deltaList, Boolean online, Boolean analytics, Integer page, Integer pageSize) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((TransactionsResponse)this.getObjectMapper().get().readValue("{\n  \"analytics\" : [ {\n    \"subCategory\" : \"subCategory\",\n    \"hotline\" : \"hotline\",\n    \"custom\" : {\n      \"key\" : \"custom\"\n    },\n    \"specification\" : \"specification\",\n    \"nextBookingDate\" : \"2000-01-23\",\n    \"cycle\" : \"cycle\",\n    \"transactionId\" : \"transactionId\",\n    \"otherAccount\" : \"otherAccount\",\n    \"mainCategory\" : \"mainCategory\",\n    \"usedRules\" : [ \"usedRules\", \"usedRules\" ],\n    \"logo\" : \"logo\",\n    \"email\" : \"email\",\n    \"homepage\" : \"homepage\"\n  }, {\n    \"subCategory\" : \"subCategory\",\n    \"hotline\" : \"hotline\",\n    \"custom\" : {\n      \"key\" : \"custom\"\n    },\n    \"specification\" : \"specification\",\n    \"nextBookingDate\" : \"2000-01-23\",\n    \"cycle\" : \"cycle\",\n    \"transactionId\" : \"transactionId\",\n    \"otherAccount\" : \"otherAccount\",\n    \"mainCategory\" : \"mainCategory\",\n    \"usedRules\" : [ \"usedRules\", \"usedRules\" ],\n    \"logo\" : \"logo\",\n    \"email\" : \"email\",\n    \"homepage\" : \"homepage\"\n  } ],\n  \"paging\" : {\n    \"pageCount\" : 10,\n    \"pageSize\" : 20,\n    \"page\" : 0,\n    \"totalCount\" : 200\n  },\n  \"transactions\" : {\n    \"booked\" : [ {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"externalResourceId\" : \"externalResourceId\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    }, {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"externalResourceId\" : \"externalResourceId\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    } ],\n    \"rawTransactions\" : \"rawTransactions\"\n  },\n  \"account\" : {\n    \"bban\" : \"BARC12345612345678\",\n    \"externalResourceId\" : \"externalResourceId\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"currency\" : \"EUR\",\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\"\n  }\n}", TransactionsResponse.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Provides consent for accounts and transactions", nickname="getTransactionsWithoutAccountId", notes="This method initiates creation of consent which then can be used for getting either accounts or transactions", response=TransactionsResponse.class, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TransactionsResponse.class), @ApiResponse(code=202, message="User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response using 'Location' header. This is soft redirection, so that FinTech should inform user about redirection. "), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankProfileID", value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xPsuAuthenticationRequired", value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="fintechUserID", value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLOK", value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLNOK", value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header"), @ApiImplicitParam(name="xCreateConsentIfNone", value="", dataType="String", paramType="header"), @ApiImplicitParam(name="xImportUserData", value="Optional, third party data like username/password of external service to be used in service session. Allows to import already existing users into this system.", dataType="String", paramType="header"), @ApiImplicitParam(name="computePSUIPAddress", value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ", dataType="Boolean", paramType="header"), @ApiImplicitParam(name="psUIPAddress", value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ", dataType="String", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<TransactionsResponse>> _getTransactionsWithoutAccountId(@ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID, @ApiParam(value="This header provides the desired URL where PSU will be redirected back after authorisation session in case of successful authorisation. This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK, @ApiParam(value="This header provides the desired URL where PSU will be redirected back  after authorisation session in case of unsuccessful authorisation (i.e. PSU's authorisation reject, technical failure, lack of credentials etc.). This URL might contain unique Identifier of this User and/or Session, recognisable by FinTech. Since authorisation may be mandated by the bank at any time, this header to be included to all service requests, even if PsuConsentSession already exists. ", required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank profile UUID identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-Profile-ID", required=false) UUID bankProfileID, @ApiParam(value="If false, login form to OPBA will not be displayed, so that authentication is not necessary. If absent or true - login form will be displayed, in order for OBG to know the PSU. ", defaultValue="true") @RequestHeader(value="X-Psu-Authentication-Required", required=false) Boolean xPsuAuthenticationRequired, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID, @ApiParam(value="") @RequestHeader(value="X-Create-Consent-If-None", required=false) String xCreateConsentIfNone, @ApiParam(value="Optional, third party data like username/password of external service to be used in service session. Allows to import already existing users into this system.") @RequestHeader(value="X-Import-User-Data", required=false) String xImportUserData, @ApiParam(value="Should be provided if consent does not exist. If false, PSU IP address should be provided in an appropriate header. If absent or true - PSU IP address will be computed by OBG. ") @RequestHeader(value="Compute-PSU-IP-Address", required=false) Boolean computePSUIPAddress, @ApiParam(value="IP address of PSU, should be provided if consent does not exist or \"Compute-Psu-Ip-Address\" header is \"false\". ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="Conditional: Starting date (inclusive the date dateFrom) of the transaction list, mandated if no delta access is required.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateFrom", required=false) LocalDate dateFrom, @ApiParam(value="End date (inclusive the data dateTo) of the transaction list, default is \"now\" if not given.  Might be ignored if a delta function is used.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateTo", required=false) LocalDate dateTo, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the transaction with identification entryReferenceFrom alternatively to the above defined period. This is a implementation of a delta access. If this data element is contained, the entries \"dateFrom\" and \"dateTo\" might be ignored by the ASPSP if a delta report is supported.  Optional if supported by API provider. ") @Valid @RequestParam(value="entryReferenceFrom", required=false) String entryReferenceFrom, @ApiParam(value="Permitted codes are   * \"booked\",   * \"pending\" and   * \"both\" To support the \"pending\" and \"both\" feature is optional for the ASPSP, Error code if not supported in the online banking frontend Default is \"booked\" ", allowableValues="booked, pending, both") @Valid @RequestParam(value="bookingStatus", required=false) String bookingStatus, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the last report access for this PSU on the addressed account. This is another implementation of a delta access-report.  This delta indicator might be rejected by the ASPSP if this function is not supported.  Optional if supported by API provider ") @Valid @RequestParam(value="deltaList", required=false) Boolean deltaList, @Min(value=0L) @ApiParam(value="Result page that you want to retrieve.  Minimum value is 0. ", allowableValues="") @Valid @RequestParam(value="page", required=false) @Min(value=0L) @Valid Integer page, @Min(value=1L) @Max(value=500L) @ApiParam(value="Maximum number of records per page.  Can be at most 500. ", allowableValues="") @Valid @RequestParam(value="pageSize", required=false) @Min(value=1L) @Max(value=500L) @Valid Integer pageSize) {
        return this.getTransactionsWithoutAccountId(serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, xTimestampUTC, xRequestSignature, fintechID, bankProfileID, xPsuAuthenticationRequired, serviceSessionID, xCreateConsentIfNone, xImportUserData, computePSUIPAddress, psUIPAddress, dateFrom, dateTo, entryReferenceFrom, bookingStatus, deltaList, page, pageSize);
    }

    default public CompletableFuture<ResponseEntity<TransactionsResponse>> getTransactionsWithoutAccountId(String serviceSessionPassword, String fintechUserID, String fintechRedirectURLOK, String fintechRedirectURLNOK, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, UUID bankProfileID, Boolean xPsuAuthenticationRequired, UUID serviceSessionID, String xCreateConsentIfNone, String xImportUserData, Boolean computePSUIPAddress, String psUIPAddress, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, String bookingStatus, Boolean deltaList, Integer page, Integer pageSize) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((TransactionsResponse)this.getObjectMapper().get().readValue("{\n  \"analytics\" : [ {\n    \"subCategory\" : \"subCategory\",\n    \"hotline\" : \"hotline\",\n    \"custom\" : {\n      \"key\" : \"custom\"\n    },\n    \"specification\" : \"specification\",\n    \"nextBookingDate\" : \"2000-01-23\",\n    \"cycle\" : \"cycle\",\n    \"transactionId\" : \"transactionId\",\n    \"otherAccount\" : \"otherAccount\",\n    \"mainCategory\" : \"mainCategory\",\n    \"usedRules\" : [ \"usedRules\", \"usedRules\" ],\n    \"logo\" : \"logo\",\n    \"email\" : \"email\",\n    \"homepage\" : \"homepage\"\n  }, {\n    \"subCategory\" : \"subCategory\",\n    \"hotline\" : \"hotline\",\n    \"custom\" : {\n      \"key\" : \"custom\"\n    },\n    \"specification\" : \"specification\",\n    \"nextBookingDate\" : \"2000-01-23\",\n    \"cycle\" : \"cycle\",\n    \"transactionId\" : \"transactionId\",\n    \"otherAccount\" : \"otherAccount\",\n    \"mainCategory\" : \"mainCategory\",\n    \"usedRules\" : [ \"usedRules\", \"usedRules\" ],\n    \"logo\" : \"logo\",\n    \"email\" : \"email\",\n    \"homepage\" : \"homepage\"\n  } ],\n  \"paging\" : {\n    \"pageCount\" : 10,\n    \"pageSize\" : 20,\n    \"page\" : 0,\n    \"totalCount\" : 200\n  },\n  \"transactions\" : {\n    \"booked\" : [ {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"externalResourceId\" : \"externalResourceId\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    }, {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"externalResourceId\" : \"externalResourceId\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    } ],\n    \"rawTransactions\" : \"rawTransactions\"\n  },\n  \"account\" : {\n    \"bban\" : \"BARC12345612345678\",\n    \"externalResourceId\" : \"externalResourceId\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"currency\" : \"EUR\",\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\"\n  }\n}", TransactionsResponse.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Update data that is associated with service session in 3rd party service(s). For example can be used to re-import connection data in 3rd party service. May require PSU re-authentication", nickname="updateExternalAisSession", notes="In cases when OBG uses 3rd party services to receive account/transactions information, those services may cache the data. This endpoint is used to refresh the cached data in those 3rd party services.", response=UpdateAisExternalSessionStatus.class, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="Update status of external service. ", response=UpdateAisExternalSessionStatus.class), @ApiResponse(code=202, message="User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response using 'Location' header. This is soft redirection, so that FinTech should inform user about redirection. "), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/{Service-Session-ID}/update"}, produces={"application/json"}, method={RequestMethod.POST})
    default public CompletableFuture<ResponseEntity<UpdateAisExternalSessionStatus>> _updateExternalAisSession(@ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", required=true) @PathVariable(value="Service-Session-ID") UUID serviceSessionID, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID) {
        return this.updateExternalAisSession(serviceSessionID, serviceSessionPassword, xRequestID, xTimestampUTC, xRequestSignature, fintechID);
    }

    default public CompletableFuture<ResponseEntity<UpdateAisExternalSessionStatus>> updateExternalAisSession(UUID serviceSessionID, String serviceSessionPassword, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity((Object)((UpdateAisExternalSessionStatus)this.getObjectMapper().get().readValue("{\n  \"status\" : \"status\"\n}", UpdateAisExternalSessionStatus.class)), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }
}

