/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.ais.model.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Container for pagination information ")
@Validated
public class Paging {
    @JsonProperty(value="page")
    private Integer page = null;
    @JsonProperty(value="pageSize")
    private Integer pageSize = null;
    @JsonProperty(value="pageCount")
    private Integer pageCount = null;
    @JsonProperty(value="totalCount")
    private Long totalCount = null;

    public Paging page(Integer page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Current page number")
    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Paging pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="20", required=true, value="Current page size (number of entries in this page)")
    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Paging pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @ApiModelProperty(example="10", required=true, value="Total number of pages")
    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public Paging totalCount(Long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Total number of entries across all pages")
    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Paging paging = (Paging)o;
        return Objects.equals(this.page, paging.page) && Objects.equals(this.pageSize, paging.pageSize) && Objects.equals(this.pageCount, paging.pageCount) && Objects.equals(this.totalCount, paging.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.pageSize, this.pageCount, this.totalCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Paging {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

