/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.ais.model.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON based analytics report. This account report contains transaction categorization result. ")
@Validated
public class AnalyticsReportDetails {
    @JsonProperty(value="transactionId")
    private String transactionId = null;
    @JsonProperty(value="mainCategory")
    private String mainCategory = null;
    @JsonProperty(value="subCategory")
    private String subCategory = null;
    @JsonProperty(value="specification")
    private String specification = null;
    @JsonProperty(value="otherAccount")
    private String otherAccount = null;
    @JsonProperty(value="logo")
    private String logo = null;
    @JsonProperty(value="homepage")
    private String homepage = null;
    @JsonProperty(value="hotline")
    private String hotline = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="custom")
    @Valid
    private Map<String, String> custom = null;
    @JsonProperty(value="usedRules")
    @Valid
    private List<String> usedRules = null;
    @JsonProperty(value="nextBookingDate")
    private LocalDate nextBookingDate = null;
    @JsonProperty(value="cycle")
    private String cycle = null;

    public AnalyticsReportDetails transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="The id of transaction this analytics result refers to.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AnalyticsReportDetails mainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
        return this;
    }

    @ApiModelProperty(value="Main category of the booking.")
    public String getMainCategory() {
        return this.mainCategory;
    }

    public void setMainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
    }

    public AnalyticsReportDetails subCategory(String subCategory) {
        this.subCategory = subCategory;
        return this;
    }

    @ApiModelProperty(value="Sub category of the booking.")
    public String getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public AnalyticsReportDetails specification(String specification) {
        this.specification = specification;
        return this;
    }

    @ApiModelProperty(value="Specification of the booking.")
    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public AnalyticsReportDetails otherAccount(String otherAccount) {
        this.otherAccount = otherAccount;
        return this;
    }

    @ApiModelProperty(value="Related account.")
    public String getOtherAccount() {
        return this.otherAccount;
    }

    public void setOtherAccount(String otherAccount) {
        this.otherAccount = otherAccount;
    }

    public AnalyticsReportDetails logo(String logo) {
        this.logo = logo;
        return this;
    }

    @ApiModelProperty(value="Logo.")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public AnalyticsReportDetails homepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    @ApiModelProperty(value="Homepage.")
    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public AnalyticsReportDetails hotline(String hotline) {
        this.hotline = hotline;
        return this;
    }

    @ApiModelProperty(value="Hotline.")
    public String getHotline() {
        return this.hotline;
    }

    public void setHotline(String hotline) {
        this.hotline = hotline;
    }

    public AnalyticsReportDetails email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Email.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public AnalyticsReportDetails custom(Map<String, String> custom) {
        this.custom = custom;
        return this;
    }

    public AnalyticsReportDetails putCustomItem(String key, String customItem) {
        if (this.custom == null) {
            this.custom = new HashMap<String, String>();
        }
        this.custom.put(key, customItem);
        return this;
    }

    @ApiModelProperty(value="Custom information about analyzed transaction.")
    public Map<String, String> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, String> custom) {
        this.custom = custom;
    }

    public AnalyticsReportDetails usedRules(List<String> usedRules) {
        this.usedRules = usedRules;
        return this;
    }

    public AnalyticsReportDetails addUsedRulesItem(String usedRulesItem) {
        if (this.usedRules == null) {
            this.usedRules = new ArrayList<String>();
        }
        this.usedRules.add(usedRulesItem);
        return this;
    }

    @ApiModelProperty(value="Rules that were used to analyze.")
    public List<String> getUsedRules() {
        return this.usedRules;
    }

    public void setUsedRules(List<String> usedRules) {
        this.usedRules = usedRules;
    }

    public AnalyticsReportDetails nextBookingDate(LocalDate nextBookingDate) {
        this.nextBookingDate = nextBookingDate;
        return this;
    }

    @ApiModelProperty(value="Classification next booking date.")
    @Valid
    public LocalDate getNextBookingDate() {
        return this.nextBookingDate;
    }

    public void setNextBookingDate(LocalDate nextBookingDate) {
        this.nextBookingDate = nextBookingDate;
    }

    public AnalyticsReportDetails cycle(String cycle) {
        this.cycle = cycle;
        return this;
    }

    @ApiModelProperty(value="Classification cycle result.")
    public String getCycle() {
        return this.cycle;
    }

    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsReportDetails analyticsReportDetails = (AnalyticsReportDetails)o;
        return Objects.equals(this.transactionId, analyticsReportDetails.transactionId) && Objects.equals(this.mainCategory, analyticsReportDetails.mainCategory) && Objects.equals(this.subCategory, analyticsReportDetails.subCategory) && Objects.equals(this.specification, analyticsReportDetails.specification) && Objects.equals(this.otherAccount, analyticsReportDetails.otherAccount) && Objects.equals(this.logo, analyticsReportDetails.logo) && Objects.equals(this.homepage, analyticsReportDetails.homepage) && Objects.equals(this.hotline, analyticsReportDetails.hotline) && Objects.equals(this.email, analyticsReportDetails.email) && Objects.equals(this.custom, analyticsReportDetails.custom) && Objects.equals(this.usedRules, analyticsReportDetails.usedRules) && Objects.equals(this.nextBookingDate, analyticsReportDetails.nextBookingDate) && Objects.equals(this.cycle, analyticsReportDetails.cycle);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.mainCategory, this.subCategory, this.specification, this.otherAccount, this.logo, this.homepage, this.hotline, this.email, this.custom, this.usedRules, this.nextBookingDate, this.cycle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsReportDetails {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    mainCategory: ").append(this.toIndentedString(this.mainCategory)).append("\n");
        sb.append("    subCategory: ").append(this.toIndentedString(this.subCategory)).append("\n");
        sb.append("    specification: ").append(this.toIndentedString(this.specification)).append("\n");
        sb.append("    otherAccount: ").append(this.toIndentedString(this.otherAccount)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    homepage: ").append(this.toIndentedString(this.homepage)).append("\n");
        sb.append("    hotline: ").append(this.toIndentedString(this.hotline)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    usedRules: ").append(this.toIndentedString(this.usedRules)).append("\n");
        sb.append("    nextBookingDate: ").append(this.toIndentedString(this.nextBookingDate)).append("\n");
        sb.append("    cycle: ").append(this.toIndentedString(this.cycle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

