/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package de.adorsys.opba.tppbankingapi.search.resource.generated;

import de.adorsys.opba.tppbankingapi.search.model.generated.BankProfileResponse;
import de.adorsys.opba.tppbankingapi.search.model.generated.BankSearchResponse;
import de.adorsys.opba.tppbankingapi.search.model.generated.GeneralError;
import java.util.UUID;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-11-17T19:48:13.910903Z[Etc/UTC]")
@Api(value = "TppBankSearch", description = "the TppBankSearch API")
public interface TppBankSearchApi {

    Logger log = LoggerFactory.getLogger(TppBankSearchApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "Request the profile of the bank identified with id (bankId).", nickname = "bankProfileGET", notes = "Request the profile of the bank identified with id (bankId).", response = BankProfileResponse.class, tags={ "TppBankSearch", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Response containing the service profile of a bank.", response = BankProfileResponse.class),
        @ApiResponse(code = 401, message = "Unauthorised. Access token absent or invalid. ", response = GeneralError.class) })
    @ApiImplicitParams({
    @ApiImplicitParam(name = "xTimestampUTC", value = "The timestamp of the operation. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestSignature", value = "A signature of the request by the TPP fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechID", value = "Unique ID that identifies fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestID", value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType = "UUID", paramType = "header")    })
    @RequestMapping(value = "/v1/banking/search/bank-profile",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<BankProfileResponse> _bankProfileGET(@ApiParam(value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. " ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID
,@NotNull @ApiParam(value = "Identifier of the bank to be loaded.", required = true) @Valid @RequestParam(value = "bankId", required = true) String bankId
,@ApiParam(value = "The timestamp of the operation. " ) @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC
,@ApiParam(value = "A signature of the request by the TPP fintech. " ) @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature
,@ApiParam(value = "Unique ID that identifies fintech. " ) @RequestHeader(value="Fintech-ID", required=false) String fintechID
) {
        return bankProfileGET(xRequestID, bankId, xTimestampUTC, xRequestSignature, fintechID);
    }

    // Override this method
    default ResponseEntity<BankProfileResponse> bankProfileGET(UUID xRequestID,String bankId,String xTimestampUTC,String xRequestSignature,String fintechID) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"bankProfileDescriptor\" : {\n    \"consentSupportByService\" : {\n      \"key\" : \"consentSupportByService\"\n    },\n    \"bankUuid\" : \"bankUuid\",\n    \"serviceList\" : [ \"serviceList\", \"serviceList\" ],\n    \"bankName\" : \"bankName\",\n    \"bic\" : \"bic\"\n  }\n}", BankProfileResponse.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankSearchApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Issues an incremental bank search request to the TppBankSearchApi.", nickname = "bankSearchGET", notes = "Issues an incremental bank search request to the TppBankSearchApi.", response = BankSearchResponse.class, tags={ "TppBankSearch", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The result of a bank search.", response = BankSearchResponse.class),
        @ApiResponse(code = 401, message = "Unauthorised. Access token absent or invalid. ", response = GeneralError.class) })
    @ApiImplicitParams({
    @ApiImplicitParam(name = "xTimestampUTC", value = "The timestamp of the operation. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestSignature", value = "A signature of the request by the TPP fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechID", value = "Unique ID that identifies fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestID", value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType = "UUID", paramType = "header")    })
    @RequestMapping(value = "/v1/banking/search/bank-search",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<BankSearchResponse> _bankSearchGET(@ApiParam(value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. " ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID
,@NotNull @ApiParam(value = "The bank search input string", required = true) @Valid @RequestParam(value = "keyword", required = true) String keyword
,@ApiParam(value = "The timestamp of the operation. " ) @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC
,@ApiParam(value = "A signature of the request by the TPP fintech. " ) @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature
,@ApiParam(value = "Unique ID that identifies fintech. " ) @RequestHeader(value="Fintech-ID", required=false) String fintechID
,@ApiParam(value = "The index of the first result") @Valid @RequestParam(value = "start", required = false) Integer start
,@ApiParam(value = "The max number of entries to return with the response.") @Valid @RequestParam(value = "max", required = false) Integer max
) {
        return bankSearchGET(xRequestID, keyword, xTimestampUTC, xRequestSignature, fintechID, start, max);
    }

    // Override this method
    default ResponseEntity<BankSearchResponse> bankSearchGET(UUID xRequestID,String keyword,String xTimestampUTC,String xRequestSignature,String fintechID,Integer start,Integer max) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"total\" : 1,\n  \"bankDescriptor\" : [ {\n    \"bankCode\" : \"bankCode\",\n    \"bankName\" : \"bankName\",\n    \"bic\" : \"bic\",\n    \"uuid\" : \"uuid\"\n  }, {\n    \"bankCode\" : \"bankCode\",\n    \"bankName\" : \"bankName\",\n    \"bic\" : \"bic\",\n    \"uuid\" : \"uuid\"\n  } ],\n  \"max\" : 6,\n  \"start\" : 0,\n  \"keyword\" : \"\"\n}", BankSearchResponse.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankSearchApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
