/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package de.adorsys.opba.tppbankingapi.pis.resource.generated;

import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentInitiation;
import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentInitiationResponse;
import java.util.UUID;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-11-17T19:48:13.241437Z[Etc/UTC]")
@Api(value = "TppBankingApiSinglePaymentPis", description = "the TppBankingApiSinglePaymentPis API")
public interface TppBankingApiSinglePaymentPisApi {

    Logger log = LoggerFactory.getLogger(TppBankingApiSinglePaymentPisApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "Payment initiation request", nickname = "initiatePayment", notes = "This method is used to initiate a payment at the ASPSP.", response = PaymentInitiationResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")    }, tags={ "TPP Banking API Single Payment (PIS)", })
    @ApiResponses(value = { 
        @ApiResponse(code = 202, message = "ACCEPTED", response = PaymentInitiationResponse.class) })
    @ApiImplicitParams({
    @ApiImplicitParam(name = "xTimestampUTC", value = "The timestamp of the operation. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestSignature", value = "A signature of the request by the TPP fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechID", value = "Unique ID that identifies fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "serviceSessionPassword", value = "Password to encrypt users' context ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "bankID", value = "A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xPisPsuAuthenticationRequired", value = "If false, login form to OPBA will not be displayed as there might be nothing to share for payments, so that authentication is not necessary. If absent or true - login form for payments will be displayed. ",  dataType = "Boolean", paramType = "header"),    @ApiImplicitParam(name = "fintechUserID", value = "An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechRedirectURLOK", value = "", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechRedirectURLNOK", value = "", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestID", value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType = "UUID", paramType = "header")    })
    @RequestMapping(value = "/v1/banking/pis/payments/{payment-product}",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default CompletableFuture<ResponseEntity<PaymentInitiationResponse>> _initiatePayment(@ApiParam(value = "" ,required=true )  @Valid @RequestBody PaymentInitiation body
,@ApiParam(value = "Password to encrypt users' context " ,required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword
,@ApiParam(value = "An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. " ,required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID
,@ApiParam(value = "" ,required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK
,@ApiParam(value = "" ,required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK
,@ApiParam(value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. " ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID
,@ApiParam(value = "",required=true, allowableValues="sepa-credit-transfers, instant-sepa-credit-transfers, target-2-payments, cross-border-credit-transfers, pain.001-sepa-credit-transfers, pain.001-instant-sepa-credit-transfers, pain.001-target-2-payments, pain.001-cross-border-credit-transfers") @PathVariable("payment-product") String paymentProduct
,@ApiParam(value = "The timestamp of the operation. " ) @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC
,@ApiParam(value = "A signature of the request by the TPP fintech. " ) @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature
,@ApiParam(value = "Unique ID that identifies fintech. " ) @RequestHeader(value="Fintech-ID", required=false) String fintechID
,@ApiParam(value = "A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. " ) @RequestHeader(value="Bank-ID", required=false) String bankID
,@ApiParam(value = "If false, login form to OPBA will not be displayed as there might be nothing to share for payments, so that authentication is not necessary. If absent or true - login form for payments will be displayed. " , defaultValue="true") @RequestHeader(value="X-Pis-Psu-Authentication-Required", required=false) Boolean xPisPsuAuthenticationRequired
) {
        return initiatePayment(body, serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, paymentProduct, xTimestampUTC, xRequestSignature, fintechID, bankID, xPisPsuAuthenticationRequired);
    }

    // Override this method
    default CompletableFuture<ResponseEntity<PaymentInitiationResponse>> initiatePayment(PaymentInitiation body,String serviceSessionPassword,String fintechUserID,String fintechRedirectURLOK,String fintechRedirectURLNOK,UUID xRequestID,String paymentProduct,String xTimestampUTC,String xRequestSignature,String fintechID,String bankID,Boolean xPisPsuAuthenticationRequired) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"msg\" : \"msg\"\n}", PaymentInitiationResponse.class), HttpStatus.NOT_IMPLEMENTED));
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return CompletableFuture.completedFuture(new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiSinglePaymentPisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED));
    }

}
