/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package de.adorsys.opba.tppbankingapi.pis.resource.generated;

import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentInformationResponse;
import de.adorsys.opba.tppbankingapi.pis.model.generated.PaymentStatusResponse;
import java.util.UUID;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-11-17T19:48:13.241437Z[Etc/UTC]")
@Api(value = "TppBankingApiPaymentStatusPis", description = "the TppBankingApiPaymentStatusPis API")
public interface TppBankingApiPaymentStatusPisApi {

    Logger log = LoggerFactory.getLogger(TppBankingApiPaymentStatusPisApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "Get payment information", nickname = "getPaymentInformation", notes = "Returns the content of a payment object", response = PaymentInformationResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")    }, tags={ "TPP Banking API Payment Status (PIS)", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = PaymentInformationResponse.class) })
    @ApiImplicitParams({
    @ApiImplicitParam(name = "xTimestampUTC", value = "The timestamp of the operation. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestSignature", value = "A signature of the request by the TPP fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechID", value = "Unique ID that identifies fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "serviceSessionPassword", value = "Password to encrypt users' context ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "bankID", value = "A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechUserID", value = "An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "serviceSessionID", value = "Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ",  dataType = "UUID", paramType = "header"),    @ApiImplicitParam(name = "xRequestID", value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType = "UUID", paramType = "header")    })
    @RequestMapping(value = "/v1/banking/pis/payments/{payment-product}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default CompletableFuture<ResponseEntity<PaymentInformationResponse>> _getPaymentInformation(@ApiParam(value = "Password to encrypt users' context " ,required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword
,@ApiParam(value = "An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. " ,required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID
,@ApiParam(value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. " ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID
,@ApiParam(value = "",required=true, allowableValues="sepa-credit-transfers, instant-sepa-credit-transfers, target-2-payments, cross-border-credit-transfers, pain.001-sepa-credit-transfers, pain.001-instant-sepa-credit-transfers, pain.001-target-2-payments, pain.001-cross-border-credit-transfers") @PathVariable("payment-product") String paymentProduct
,@ApiParam(value = "The timestamp of the operation. " ) @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC
,@ApiParam(value = "A signature of the request by the TPP fintech. " ) @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature
,@ApiParam(value = "Unique ID that identifies fintech. " ) @RequestHeader(value="Fintech-ID", required=false) String fintechID
,@ApiParam(value = "A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. " ) @RequestHeader(value="Bank-ID", required=false) String bankID
,@ApiParam(value = "Unique ID that identifies service session. Can be used for batch processing to correlate input and output. " ) @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID
) {
        return getPaymentInformation(serviceSessionPassword, fintechUserID, xRequestID, paymentProduct, xTimestampUTC, xRequestSignature, fintechID, bankID, serviceSessionID);
    }

    // Override this method
    default CompletableFuture<ResponseEntity<PaymentInformationResponse>> getPaymentInformation(String serviceSessionPassword,String fintechUserID,UUID xRequestID,String paymentProduct,String xTimestampUTC,String xRequestSignature,String fintechID,String bankID,UUID serviceSessionID) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"debtorAccount\" : {\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"currency\" : \"EUR\",\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\"\n  },\n  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"creditorAddress\" : {\n    \"street\" : \"rue blue\",\n    \"buildingnNumber\" : \"89\",\n    \"city\" : \"Paris\",\n    \"postalCode\" : \"75000\",\n    \"country\" : \"FR\"\n  },\n  \"creditorName\" : \"Creditor Name\",\n  \"creditorAgent\" : \"AAAADEBBXXX\",\n  \"transactionStatus\" : \"transactionStatus\",\n  \"instructedAmount\" : {\n    \"currency\" : \"EUR\",\n    \"amount\" : \"123\"\n  },\n  \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n  \"endToEndIdentification\" : \"endToEndIdentification\"\n}", PaymentInformationResponse.class), HttpStatus.NOT_IMPLEMENTED));
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return CompletableFuture.completedFuture(new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiPaymentStatusPisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED));
    }


    @ApiOperation(value = "Payment initiation status request", nickname = "getPaymentStatus", notes = "Check the transaction status of a payment initiation.", response = PaymentStatusResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")    }, tags={ "TPP Banking API Payment Status (PIS)", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = PaymentStatusResponse.class) })
    @ApiImplicitParams({
    @ApiImplicitParam(name = "xTimestampUTC", value = "The timestamp of the operation. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestSignature", value = "A signature of the request by the TPP fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechID", value = "Unique ID that identifies fintech. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "serviceSessionPassword", value = "Password to encrypt users' context ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "bankID", value = "A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "fintechUserID", value = "An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "serviceSessionID", value = "Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ",  dataType = "UUID", paramType = "header"),    @ApiImplicitParam(name = "xRequestID", value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType = "UUID", paramType = "header")    })
    @RequestMapping(value = "/v1/banking/pis/payments/{payment-product}/status",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default CompletableFuture<ResponseEntity<PaymentStatusResponse>> _getPaymentStatus(@ApiParam(value = "Password to encrypt users' context " ,required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword
,@ApiParam(value = "An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. " ,required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID
,@ApiParam(value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. " ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID
,@ApiParam(value = "",required=true, allowableValues="sepa-credit-transfers, instant-sepa-credit-transfers, target-2-payments, cross-border-credit-transfers, pain.001-sepa-credit-transfers, pain.001-instant-sepa-credit-transfers, pain.001-target-2-payments, pain.001-cross-border-credit-transfers") @PathVariable("payment-product") String paymentProduct
,@ApiParam(value = "The timestamp of the operation. " ) @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC
,@ApiParam(value = "A signature of the request by the TPP fintech. " ) @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature
,@ApiParam(value = "Unique ID that identifies fintech. " ) @RequestHeader(value="Fintech-ID", required=false) String fintechID
,@ApiParam(value = "A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. " ) @RequestHeader(value="Bank-ID", required=false) String bankID
,@ApiParam(value = "Unique ID that identifies service session. Can be used for batch processing to correlate input and output. " ) @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID
) {
        return getPaymentStatus(serviceSessionPassword, fintechUserID, xRequestID, paymentProduct, xTimestampUTC, xRequestSignature, fintechID, bankID, serviceSessionID);
    }

    // Override this method
    default CompletableFuture<ResponseEntity<PaymentStatusResponse>> getPaymentStatus(String serviceSessionPassword,String fintechUserID,UUID xRequestID,String paymentProduct,String xTimestampUTC,String xRequestSignature,String fintechID,String bankID,UUID serviceSessionID) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",\n  \"transactionStatus\" : \"transactionStatus\",\n  \"fundsAvailable\" : true,\n  \"psuMessage\" : \"psuMessage\"\n}", PaymentStatusResponse.class), HttpStatus.NOT_IMPLEMENTED));
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return CompletableFuture.completedFuture(new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiPaymentStatusPisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED));
    }

}
