/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.search.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppbankingapi.search.model.generated.BankProfileResponse;
import de.adorsys.opba.tppbankingapi.search.model.generated.BankSearchResponse;
import de.adorsys.opba.tppbankingapi.search.model.generated.GeneralError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="TppBankSearch", description="the TppBankSearch API")
public interface TppBankSearchApi {
    public static final Logger log = LoggerFactory.getLogger(TppBankSearchApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Request the profile of the bank identified with id (bankId).", nickname="bankProfileGET", notes="Request the profile of the bank identified with id (bankId).", response=BankProfileResponse.class, tags={"TppBankSearch"})
    @ApiResponses(value={@ApiResponse(code=200, message="Response containing the service profile of a bank.", response=BankProfileResponse.class), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/search/bank-profile"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<BankProfileResponse> _bankProfileGET(@ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @NotNull @ApiParam(value="Identifier of the bank to be loaded.", required=true) @Valid @RequestParam(value="bankId", required=true) String bankId, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID) {
        return this.bankProfileGET(xRequestID, bankId, xTimestampUTC, xRequestSignature, fintechID);
    }

    default public ResponseEntity<BankProfileResponse> bankProfileGET(UUID xRequestID, String bankId, String xTimestampUTC, String xRequestSignature, String fintechID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity(this.getObjectMapper().get().readValue("{\n  \"bankProfileDescriptor\" : {\n    \"consentSupportByService\" : {\n      \"key\" : \"consentSupportByService\"\n    },\n    \"bankUuid\" : \"bankUuid\",\n    \"serviceList\" : [ \"serviceList\", \"serviceList\" ],\n    \"bankName\" : \"bankName\",\n    \"bic\" : \"bic\"\n  }\n}", BankProfileResponse.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankSearchApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Issues an incremental bank search request to the TppBankSearchApi.", nickname="bankSearchGET", notes="Issues an incremental bank search request to the TppBankSearchApi.", response=BankSearchResponse.class, tags={"TppBankSearch"})
    @ApiResponses(value={@ApiResponse(code=200, message="The result of a bank search.", response=BankSearchResponse.class), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/search/bank-search"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<BankSearchResponse> _bankSearchGET(@ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @NotNull @ApiParam(value="The bank search input string", required=true) @Valid @RequestParam(value="keyword", required=true) String keyword, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="The index of the first result") @Valid @RequestParam(value="start", required=false) Integer start, @ApiParam(value="The max number of entries to return with the response.") @Valid @RequestParam(value="max", required=false) Integer max) {
        return this.bankSearchGET(xRequestID, keyword, xTimestampUTC, xRequestSignature, fintechID, start, max);
    }

    default public ResponseEntity<BankSearchResponse> bankSearchGET(UUID xRequestID, String keyword, String xTimestampUTC, String xRequestSignature, String fintechID, Integer start, Integer max) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity(this.getObjectMapper().get().readValue("{\n  \"total\" : 1,\n  \"bankDescriptor\" : [ {\n    \"bankCode\" : \"bankCode\",\n    \"bankName\" : \"bankName\",\n    \"bic\" : \"bic\",\n    \"uuid\" : \"uuid\"\n  }, {\n    \"bankCode\" : \"bankCode\",\n    \"bankName\" : \"bankName\",\n    \"bic\" : \"bic\",\n    \"uuid\" : \"uuid\"\n  } ],\n  \"max\" : 6,\n  \"start\" : 0,\n  \"keyword\" : \"\"\n}", BankSearchResponse.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankSearchApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

