/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.pis.model.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.opba.tppbankingapi.pis.model.generated.AccountReference;
import de.adorsys.opba.tppbankingapi.pis.model.generated.Address;
import de.adorsys.opba.tppbankingapi.pis.model.generated.Amount;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class PaymentInitiation {
    @JsonProperty(value="endToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="instructedAmount")
    private Amount instructedAmount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorAgentName")
    private String creditorAgentName = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="requestedExecutionDate")
    private LocalDate requestedExecutionDate = null;
    @JsonProperty(value="requestedExecutionTime")
    private String requestedExecutionTime = null;
    @JsonProperty(value="instantPayment")
    private Boolean instantPayment = null;

    public PaymentInitiation endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    public @Size(max=35) String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public PaymentInitiation debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public PaymentInitiation instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public PaymentInitiation creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public PaymentInitiation creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public PaymentInitiation creditorAgentName(String creditorAgentName) {
        this.creditorAgentName = creditorAgentName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    public @Size(max=70) String getCreditorAgentName() {
        return this.creditorAgentName;
    }

    public void setCreditorAgentName(String creditorAgentName) {
        this.creditorAgentName = creditorAgentName;
    }

    public PaymentInitiation creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=70)
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public PaymentInitiation creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public PaymentInitiation remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public PaymentInitiation requestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public PaymentInitiation requestedExecutionTime(String requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public void setRequestedExecutionTime(String requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public PaymentInitiation instantPayment(Boolean instantPayment) {
        this.instantPayment = instantPayment;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isInstantPayment() {
        return this.instantPayment;
    }

    public void setInstantPayment(Boolean instantPayment) {
        this.instantPayment = instantPayment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiation paymentInitiation = (PaymentInitiation)o;
        return Objects.equals(this.endToEndIdentification, paymentInitiation.endToEndIdentification) && Objects.equals(this.debtorAccount, paymentInitiation.debtorAccount) && Objects.equals(this.instructedAmount, paymentInitiation.instructedAmount) && Objects.equals(this.creditorAccount, paymentInitiation.creditorAccount) && Objects.equals(this.creditorAgent, paymentInitiation.creditorAgent) && Objects.equals(this.creditorAgentName, paymentInitiation.creditorAgentName) && Objects.equals(this.creditorName, paymentInitiation.creditorName) && Objects.equals(this.creditorAddress, paymentInitiation.creditorAddress) && Objects.equals(this.remittanceInformationUnstructured, paymentInitiation.remittanceInformationUnstructured) && Objects.equals(this.requestedExecutionDate, paymentInitiation.requestedExecutionDate) && Objects.equals(this.requestedExecutionTime, paymentInitiation.requestedExecutionTime) && Objects.equals(this.instantPayment, paymentInitiation.instantPayment);
    }

    public int hashCode() {
        return Objects.hash(this.endToEndIdentification, this.debtorAccount, this.instructedAmount, this.creditorAccount, this.creditorAgent, this.creditorAgentName, this.creditorName, this.creditorAddress, this.remittanceInformationUnstructured, this.requestedExecutionDate, this.requestedExecutionTime, this.instantPayment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiation {\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAgentName: ").append(this.toIndentedString(this.creditorAgentName)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    requestedExecutionDate: ").append(this.toIndentedString(this.requestedExecutionDate)).append("\n");
        sb.append("    requestedExecutionTime: ").append(this.toIndentedString(this.requestedExecutionTime)).append("\n");
        sb.append("    instantPayment: ").append(this.toIndentedString(this.instantPayment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

