/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.pis.model.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.opba.tppbankingapi.pis.model.generated.AccountReference;
import de.adorsys.opba.tppbankingapi.pis.model.generated.Address;
import de.adorsys.opba.tppbankingapi.pis.model.generated.Amount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Generic JSON response body consistion of the corresponding payment initation JSON body together with an optional transaction status field. ")
@Validated
public class PaymentInformationResponse {
    @JsonProperty(value="endToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="instructedAmount")
    private Amount instructedAmount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="transactionStatus")
    private String transactionStatus = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;

    public PaymentInformationResponse endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    public @Size(max=35) String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public PaymentInformationResponse debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public PaymentInformationResponse instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public PaymentInformationResponse creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public PaymentInformationResponse creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public PaymentInformationResponse creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=70)
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public PaymentInformationResponse creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public PaymentInformationResponse remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public PaymentInformationResponse transactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public String getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public PaymentInformationResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInformationResponse paymentInformationResponse = (PaymentInformationResponse)o;
        return Objects.equals(this.endToEndIdentification, paymentInformationResponse.endToEndIdentification) && Objects.equals(this.debtorAccount, paymentInformationResponse.debtorAccount) && Objects.equals(this.instructedAmount, paymentInformationResponse.instructedAmount) && Objects.equals(this.creditorAccount, paymentInformationResponse.creditorAccount) && Objects.equals(this.creditorAgent, paymentInformationResponse.creditorAgent) && Objects.equals(this.creditorName, paymentInformationResponse.creditorName) && Objects.equals(this.creditorAddress, paymentInformationResponse.creditorAddress) && Objects.equals(this.remittanceInformationUnstructured, paymentInformationResponse.remittanceInformationUnstructured) && Objects.equals(this.transactionStatus, paymentInformationResponse.transactionStatus) && Objects.equals(this.createdAt, paymentInformationResponse.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.endToEndIdentification, this.debtorAccount, this.instructedAmount, this.creditorAccount, this.creditorAgent, this.creditorName, this.creditorAddress, this.remittanceInformationUnstructured, this.transactionStatus, this.createdAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInformationResponse {\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString(this.transactionStatus)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

