/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.ais.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppbankingapi.ais.model.generated.AccountList;
import de.adorsys.opba.tppbankingapi.ais.model.generated.GeneralError;
import de.adorsys.opba.tppbankingapi.ais.model.generated.TransactionsResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="TppBankingApiAccountInformationServiceAis", description="the TppBankingApiAccountInformationServiceAis API")
public interface TppBankingApiAccountInformationServiceAisApi {
    public static final Logger log = LoggerFactory.getLogger(TppBankingApiAccountInformationServiceAisApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Provides list of available accounts", nickname="getAccounts", notes="Read the identifiers of the available payment accounts. It is assumed that a consent of the PSU to this access is already given and stored on the TPP system. The addressed list of accounts depends then on the PSU and Consent information, stored respectively the OAuth2 access token. Returns all identifiers of the accounts, to which an account access has been granted to by the PSU. In addition, relevant information about the accounts and hyperlinks to corresponding account information resources are provided if a related consent has been already granted.", response=AccountList.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AccountList.class), @ApiResponse(code=202, message="User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response using 'Location' header. This is soft redirection, so that FinTech should inform user about redirection. "), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class), @ApiResponse(code=410, message="The headerfield tells what exactly was wrong. "), @ApiResponse(code=429, message="The headerfield tells what exactly was wrong. ")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankID", value="A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechUserID", value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLOK", value="", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLNOK", value="", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="psUConsentSession", value="Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/accounts"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<AccountList>> _getAccounts(@ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID, @ApiParam(value="", required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK, @ApiParam(value="", required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-ID", required=false) String bankID, @ApiParam(value="Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ") @RequestHeader(value="PSU-Consent-Session", required=false) String psUConsentSession, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID, @ApiParam(value="For list of accounts this query param defines to not only look for the accounts, but for the balances too. ") @Valid @RequestParam(value="withBalance", required=false) Boolean withBalance) {
        return this.getAccounts(serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, xTimestampUTC, xRequestSignature, fintechID, bankID, psUConsentSession, serviceSessionID, withBalance);
    }

    default public CompletableFuture<ResponseEntity<AccountList>> getAccounts(String serviceSessionPassword, String fintechUserID, String fintechRedirectURLOK, String fintechRedirectURLNOK, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, String bankID, String psUConsentSession, UUID serviceSessionID, Boolean withBalance) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity(this.getObjectMapper().get().readValue("{\n  \"accounts\" : [ {\n    \"cashAccountType\" : \"cashAccountType\",\n    \"resourceId\" : \"resourceId\",\n    \"product\" : \"product\",\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"_links\" : {\n      \"balances\" : {\n        \"href\" : \"https://www.example.com/path/resource?parameter=value\"\n      }\n    },\n    \"usage\" : \"PRIV\",\n    \"balances\" : [ {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    }, {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    } ],\n    \"ownerName\" : \"ownerName\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"name\" : \"name\",\n    \"linkedAccounts\" : \"linkedAccounts\",\n    \"currency\" : \"EUR\",\n    \"details\" : \"details\",\n    \"ownerAddress\" : {\n      \"street\" : \"rue blue\",\n      \"buildingnNumber\" : \"89\",\n      \"city\" : \"Paris\",\n      \"postalCode\" : \"75000\",\n      \"country\" : \"FR\"\n    },\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\",\n    \"bic\" : \"AAAADEBBXXX\",\n    \"status\" : \"enabled\"\n  }, {\n    \"cashAccountType\" : \"cashAccountType\",\n    \"resourceId\" : \"resourceId\",\n    \"product\" : \"product\",\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"_links\" : {\n      \"balances\" : {\n        \"href\" : \"https://www.example.com/path/resource?parameter=value\"\n      }\n    },\n    \"usage\" : \"PRIV\",\n    \"balances\" : [ {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    }, {\n      \"balanceType\" : \"balanceType\",\n      \"lastChangedDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\n      \"balanceAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"referenceDate\" : \"referenceDate\"\n    } ],\n    \"ownerName\" : \"ownerName\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"name\" : \"name\",\n    \"linkedAccounts\" : \"linkedAccounts\",\n    \"currency\" : \"EUR\",\n    \"details\" : \"details\",\n    \"ownerAddress\" : {\n      \"street\" : \"rue blue\",\n      \"buildingnNumber\" : \"89\",\n      \"city\" : \"Paris\",\n      \"postalCode\" : \"75000\",\n      \"country\" : \"FR\"\n    },\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\",\n    \"bic\" : \"AAAADEBBXXX\",\n    \"status\" : \"enabled\"\n  } ]\n}", AccountList.class), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Provides list of transactions by given account", nickname="getTransactions", notes="returns list of transactions for specified account resource ID in case Service-Session-ID is provided and saved consent on tpp by it found. Otherwise initiates creation of new consent", response=TransactionsResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TransactionsResponse.class), @ApiResponse(code=202, message="User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response using 'Location' header. This is soft redirection, so that FinTech should inform user about redirection. "), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankID", value="A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechUserID", value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLOK", value="", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLNOK", value="", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="psUConsentSession", value="Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/accounts/{account-id}/transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<TransactionsResponse>> _getTransactions(@ApiParam(value="", required=true) @PathVariable(value="account-id") String accountId, @ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID, @ApiParam(value="", required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK, @ApiParam(value="", required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-ID", required=false) String bankID, @ApiParam(value="Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ") @RequestHeader(value="PSU-Consent-Session", required=false) String psUConsentSession, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID, @ApiParam(value="Conditional: Starting date (inclusive the date dateFrom) of the transaction list, mandated if no delta access is required.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateFrom", required=false) LocalDate dateFrom, @ApiParam(value="End date (inclusive the data dateTo) of the transaction list, default is \"now\" if not given.  Might be ignored if a delta function is used.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateTo", required=false) LocalDate dateTo, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the transaction with identification entryReferenceFrom alternatively to the above defined period. This is a implementation of a delta access. If this data element is contained, the entries \"dateFrom\" and \"dateTo\" might be ignored by the ASPSP if a delta report is supported.  Optional if supported by API provider. ") @Valid @RequestParam(value="entryReferenceFrom", required=false) String entryReferenceFrom, @ApiParam(value="Permitted codes are   * \"booked\",   * \"pending\" and   * \"both\" To support the \"pending\" and \"both\" feature is optional for the ASPSP, Error code if not supported in the online banking frontend Default is \"booked\" ", allowableValues="booked, pending, both") @Valid @RequestParam(value="bookingStatus", required=false) String bookingStatus, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the last report access for this PSU on the addressed account. This is another implementation of a delta access-report.  This delta indicator might be rejected by the ASPSP if this function is not supported.  Optional if supported by API provider ") @Valid @RequestParam(value="deltaList", required=false) Boolean deltaList) {
        return this.getTransactions(accountId, serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, xTimestampUTC, xRequestSignature, fintechID, bankID, psUConsentSession, serviceSessionID, dateFrom, dateTo, entryReferenceFrom, bookingStatus, deltaList);
    }

    default public CompletableFuture<ResponseEntity<TransactionsResponse>> getTransactions(String accountId, String serviceSessionPassword, String fintechUserID, String fintechRedirectURLOK, String fintechRedirectURLNOK, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, String bankID, String psUConsentSession, UUID serviceSessionID, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, String bookingStatus, Boolean deltaList) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity(this.getObjectMapper().get().readValue("{\n  \"transactions\" : {\n    \"booked\" : [ {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    }, {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    } ]\n  },\n  \"account\" : {\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"currency\" : \"EUR\",\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\"\n  }\n}", TransactionsResponse.class), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }

    @ApiOperation(value="Provides consent for accounts and transactions", nickname="getTransactionsWithoutAccountId", notes="This method initiates creation of consent which then can be used for getting either accounts or transactions", response=TransactionsResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={"TPP Banking API Account information service (AIS)"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=TransactionsResponse.class), @ApiResponse(code=202, message="User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response using 'Location' header. This is soft redirection, so that FinTech should inform user about redirection. "), @ApiResponse(code=401, message="Unauthorised. Access token absent or invalid. ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xTimestampUTC", value="The timestamp of the operation. ", dataType="String", paramType="header"), @ApiImplicitParam(name="xRequestSignature", value="A signature of the request by the TPP fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechID", value="Unique ID that identifies fintech. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionPassword", value="Password to encrypt users' context ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="bankID", value="A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ", dataType="String", paramType="header"), @ApiImplicitParam(name="fintechUserID", value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLOK", value="", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="fintechRedirectURLNOK", value="", required=true, dataType="String", paramType="header"), @ApiImplicitParam(name="psUConsentSession", value="Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ", dataType="String", paramType="header"), @ApiImplicitParam(name="serviceSessionID", value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ", dataType="UUID", paramType="header"), @ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/banking/ais/transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    default public CompletableFuture<ResponseEntity<TransactionsResponse>> _getTransactionsWithoutAccountId(@ApiParam(value="Password to encrypt users' context ", required=true) @RequestHeader(value="Service-Session-Password", required=true) String serviceSessionPassword, @ApiParam(value="An End-User identifier, known by FinTech, that unique for each physical person. To be provided by FinTech with every request in order to validate the mapping of service request to the particular user. ", required=true) @RequestHeader(value="Fintech-User-ID", required=true) String fintechUserID, @ApiParam(value="", required=true) @RequestHeader(value="Fintech-Redirect-URL-OK", required=true) String fintechRedirectURLOK, @ApiParam(value="", required=true) @RequestHeader(value="Fintech-Redirect-URL-NOK", required=true) String fintechRedirectURLNOK, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The timestamp of the operation. ") @RequestHeader(value="X-Timestamp-UTC", required=false) String xTimestampUTC, @ApiParam(value="A signature of the request by the TPP fintech. ") @RequestHeader(value="X-Request-Signature", required=false) String xRequestSignature, @ApiParam(value="Unique ID that identifies fintech. ") @RequestHeader(value="Fintech-ID", required=false) String fintechID, @ApiParam(value="A bank identifier, provided by TPP Bank Search API. To be provided by FinTech only if PsuConsentSession is missing. ") @RequestHeader(value="Bank-ID", required=false) String bankID, @ApiParam(value="Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ") @RequestHeader(value="PSU-Consent-Session", required=false) String psUConsentSession, @ApiParam(value="Unique ID that identifies service session. Can be used for batch processing to correlate input and output. ") @RequestHeader(value="Service-Session-ID", required=false) UUID serviceSessionID, @ApiParam(value="Conditional: Starting date (inclusive the date dateFrom) of the transaction list, mandated if no delta access is required.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateFrom", required=false) LocalDate dateFrom, @ApiParam(value="End date (inclusive the data dateTo) of the transaction list, default is \"now\" if not given.  Might be ignored if a delta function is used.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value="dateTo", required=false) LocalDate dateTo, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the transaction with identification entryReferenceFrom alternatively to the above defined period. This is a implementation of a delta access. If this data element is contained, the entries \"dateFrom\" and \"dateTo\" might be ignored by the ASPSP if a delta report is supported.  Optional if supported by API provider. ") @Valid @RequestParam(value="entryReferenceFrom", required=false) String entryReferenceFrom, @ApiParam(value="Permitted codes are   * \"booked\",   * \"pending\" and   * \"both\" To support the \"pending\" and \"both\" feature is optional for the ASPSP, Error code if not supported in the online banking frontend Default is \"booked\" ", allowableValues="booked, pending, both") @Valid @RequestParam(value="bookingStatus", required=false) String bookingStatus, @ApiParam(value="This data attribute is indicating that the AISP is in favour to get all transactions after the last report access for this PSU on the addressed account. This is another implementation of a delta access-report.  This delta indicator might be rejected by the ASPSP if this function is not supported.  Optional if supported by API provider ") @Valid @RequestParam(value="deltaList", required=false) Boolean deltaList) {
        return this.getTransactionsWithoutAccountId(serviceSessionPassword, fintechUserID, fintechRedirectURLOK, fintechRedirectURLNOK, xRequestID, xTimestampUTC, xRequestSignature, fintechID, bankID, psUConsentSession, serviceSessionID, dateFrom, dateTo, entryReferenceFrom, bookingStatus, deltaList);
    }

    default public CompletableFuture<ResponseEntity<TransactionsResponse>> getTransactionsWithoutAccountId(String serviceSessionPassword, String fintechUserID, String fintechRedirectURLOK, String fintechRedirectURLNOK, UUID xRequestID, String xTimestampUTC, String xRequestSignature, String fintechID, String bankID, String psUConsentSession, UUID serviceSessionID, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, String bookingStatus, Boolean deltaList) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return CompletableFuture.completedFuture(new ResponseEntity(this.getObjectMapper().get().readValue("{\n  \"transactions\" : {\n    \"booked\" : [ {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    }, {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    } ]\n  },\n  \"account\" : {\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"currency\" : \"EUR\",\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\"\n  }\n}", TransactionsResponse.class), HttpStatus.NOT_IMPLEMENTED));
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return CompletableFuture.completedFuture(new ResponseEntity(HttpStatus.NOT_IMPLEMENTED));
    }
}

