/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppbankingapi.ais.model.generated;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.opba.tppbankingapi.ais.model.generated.AccountReference;
import de.adorsys.opba.tppbankingapi.ais.model.generated.Amount;
import de.adorsys.opba.tppbankingapi.ais.model.generated.PurposeCode;
import de.adorsys.opba.tppbankingapi.ais.model.generated.ReportExchangeRateList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Transaction details.")
@Validated
public class TransactionDetails {
    @JsonProperty(value="transactionId")
    private String transactionId = null;
    @JsonProperty(value="entryReference")
    private String entryReference = null;
    @JsonProperty(value="endToEndId")
    private String endToEndId = null;
    @JsonProperty(value="mandateId")
    private String mandateId = null;
    @JsonProperty(value="checkId")
    private String checkId = null;
    @JsonProperty(value="creditorId")
    private String creditorId = null;
    @JsonProperty(value="bookingDate")
    private LocalDate bookingDate = null;
    @JsonProperty(value="valueDate")
    private LocalDate valueDate = null;
    @JsonProperty(value="transactionAmount")
    private Amount transactionAmount = null;
    @JsonProperty(value="currencyExchange")
    private ReportExchangeRateList currencyExchange = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="ultimateCreditor")
    private String ultimateCreditor = null;
    @JsonProperty(value="debtorName")
    private String debtorName = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="ultimateDebtor")
    private String ultimateDebtor = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="remittanceInformationStructured")
    private String remittanceInformationStructured = null;
    @JsonProperty(value="additionalInformation")
    private String additionalInformation = null;
    @JsonProperty(value="purposeCode")
    private PurposeCode purposeCode = null;
    @JsonProperty(value="bankTransactionCode")
    private String bankTransactionCode = null;
    @JsonProperty(value="proprietaryBankTransactionCode")
    private String proprietaryBankTransactionCode = null;

    public TransactionDetails transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="the Transaction Id can be used as access-ID in the API, where more details on an transaction is offered. If this data attribute is provided this shows that the AIS can get access on more details about this transaction using the Get transaction details request. ")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionDetails entryReference(String entryReference) {
        this.entryReference = entryReference;
        return this;
    }

    @ApiModelProperty(value="Is the identification of the transaction as used e.g. for reference for deltafunction on application level. The same identification as for example used within camt.05x messages. ")
    @Size(max=35)
    public @Size(max=35) String getEntryReference() {
        return this.entryReference;
    }

    public void setEntryReference(String entryReference) {
        this.entryReference = entryReference;
    }

    public TransactionDetails endToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
        return this;
    }

    @ApiModelProperty(value="Unique end to end identity.")
    @Size(max=35)
    public @Size(max=35) String getEndToEndId() {
        return this.endToEndId;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    public TransactionDetails mandateId(String mandateId) {
        this.mandateId = mandateId;
        return this;
    }

    @ApiModelProperty(value="Identification of Mandates, e.g. a SEPA Mandate ID.")
    @Size(max=35)
    public @Size(max=35) String getMandateId() {
        return this.mandateId;
    }

    public void setMandateId(String mandateId) {
        this.mandateId = mandateId;
    }

    public TransactionDetails checkId(String checkId) {
        this.checkId = checkId;
        return this;
    }

    @ApiModelProperty(value="Identification of a Cheque.")
    @Size(max=35)
    public @Size(max=35) String getCheckId() {
        return this.checkId;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    public TransactionDetails creditorId(String creditorId) {
        this.creditorId = creditorId;
        return this;
    }

    @ApiModelProperty(value="Identification of Creditors, e.g. a SEPA Creditor ID.")
    @Size(max=35)
    public @Size(max=35) String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public TransactionDetails bookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LocalDate getBookingDate() {
        return this.bookingDate;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
    }

    public TransactionDetails valueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(value="The Date at which assets become available to the account owner in case of a credit.")
    @Valid
    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
    }

    public TransactionDetails transactionAmount(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public TransactionDetails currencyExchange(ReportExchangeRateList currencyExchange) {
        this.currencyExchange = currencyExchange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ReportExchangeRateList getCurrencyExchange() {
        return this.currencyExchange;
    }

    public void setCurrencyExchange(ReportExchangeRateList currencyExchange) {
        this.currencyExchange = currencyExchange;
    }

    public TransactionDetails creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    public @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public TransactionDetails creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public TransactionDetails ultimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    public @Size(max=70) String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public TransactionDetails debtorName(String debtorName) {
        this.debtorName = debtorName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    public @Size(max=70) String getDebtorName() {
        return this.debtorName;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public TransactionDetails debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public TransactionDetails ultimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    public @Size(max=70) String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public TransactionDetails remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public TransactionDetails remittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
        return this;
    }

    @ApiModelProperty(value="Reference as contained in the structured remittance reference structure (without the surrounding XML structure).  Different from other places the content is containt in plain form not in form of a structered field. ")
    @Size(max=140)
    public @Size(max=140) String getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public void setRemittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public TransactionDetails additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @ApiModelProperty(value="Might be used by the ASPSP to transport additional transaction related information to the PSU. ")
    @Size(max=512)
    public @Size(max=512) String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public TransactionDetails purposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public TransactionDetails bankTransactionCode(String bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    public String getBankTransactionCode() {
        return this.bankTransactionCode;
    }

    public void setBankTransactionCode(String bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
    }

    public TransactionDetails proprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    public @Size(max=35) String getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setProprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionDetails transactionDetails = (TransactionDetails)o;
        return Objects.equals(this.transactionId, transactionDetails.transactionId) && Objects.equals(this.entryReference, transactionDetails.entryReference) && Objects.equals(this.endToEndId, transactionDetails.endToEndId) && Objects.equals(this.mandateId, transactionDetails.mandateId) && Objects.equals(this.checkId, transactionDetails.checkId) && Objects.equals(this.creditorId, transactionDetails.creditorId) && Objects.equals(this.bookingDate, transactionDetails.bookingDate) && Objects.equals(this.valueDate, transactionDetails.valueDate) && Objects.equals(this.transactionAmount, transactionDetails.transactionAmount) && Objects.equals(this.currencyExchange, transactionDetails.currencyExchange) && Objects.equals(this.creditorName, transactionDetails.creditorName) && Objects.equals(this.creditorAccount, transactionDetails.creditorAccount) && Objects.equals(this.ultimateCreditor, transactionDetails.ultimateCreditor) && Objects.equals(this.debtorName, transactionDetails.debtorName) && Objects.equals(this.debtorAccount, transactionDetails.debtorAccount) && Objects.equals(this.ultimateDebtor, transactionDetails.ultimateDebtor) && Objects.equals(this.remittanceInformationUnstructured, transactionDetails.remittanceInformationUnstructured) && Objects.equals(this.remittanceInformationStructured, transactionDetails.remittanceInformationStructured) && Objects.equals(this.additionalInformation, transactionDetails.additionalInformation) && Objects.equals((Object)this.purposeCode, (Object)transactionDetails.purposeCode) && Objects.equals(this.bankTransactionCode, transactionDetails.bankTransactionCode) && Objects.equals(this.proprietaryBankTransactionCode, transactionDetails.proprietaryBankTransactionCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionId, this.entryReference, this.endToEndId, this.mandateId, this.checkId, this.creditorId, this.bookingDate, this.valueDate, this.transactionAmount, this.currencyExchange, this.creditorName, this.creditorAccount, this.ultimateCreditor, this.debtorName, this.debtorAccount, this.ultimateDebtor, this.remittanceInformationUnstructured, this.remittanceInformationStructured, this.additionalInformation, this.purposeCode, this.bankTransactionCode, this.proprietaryBankTransactionCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionDetails {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    entryReference: ").append(this.toIndentedString(this.entryReference)).append("\n");
        sb.append("    endToEndId: ").append(this.toIndentedString(this.endToEndId)).append("\n");
        sb.append("    mandateId: ").append(this.toIndentedString(this.mandateId)).append("\n");
        sb.append("    checkId: ").append(this.toIndentedString(this.checkId)).append("\n");
        sb.append("    creditorId: ").append(this.toIndentedString(this.creditorId)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("    currencyExchange: ").append(this.toIndentedString(this.currencyExchange)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    ultimateCreditor: ").append(this.toIndentedString(this.ultimateCreditor)).append("\n");
        sb.append("    debtorName: ").append(this.toIndentedString(this.debtorName)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    ultimateDebtor: ").append(this.toIndentedString(this.ultimateDebtor)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    remittanceInformationStructured: ").append(this.toIndentedString(this.remittanceInformationStructured)).append("\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("    purposeCode: ").append(this.toIndentedString((Object)this.purposeCode)).append("\n");
        sb.append("    bankTransactionCode: ").append(this.toIndentedString(this.bankTransactionCode)).append("\n");
        sb.append("    proprietaryBankTransactionCode: ").append(this.toIndentedString(this.proprietaryBankTransactionCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

