package de.adorsys.opba.tppbankingapi.search.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import de.adorsys.opba.tppbankingapi.search.model.BankDescriptor;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * BankSearchResponse
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-01-20T14:29:11.729Z[UTC]")
public class BankSearchResponse   {
  @JsonProperty("bankDescriptor")
  @Valid
  private List<BankDescriptor> bankDescriptor = null;

  @JsonProperty("keyword")
  private String keyword = null;

  @JsonProperty("start")
  private Integer start = null;

  @JsonProperty("max")
  private Integer max = null;

  @JsonProperty("total")
  private Integer total = null;

  public BankSearchResponse bankDescriptor(List<BankDescriptor> bankDescriptor) {
    this.bankDescriptor = bankDescriptor;
    return this;
  }

  public BankSearchResponse addBankDescriptorItem(BankDescriptor bankDescriptorItem) {
    if (this.bankDescriptor == null) {
      this.bankDescriptor = new ArrayList<>();
    }
    this.bankDescriptor.add(bankDescriptorItem);
    return this;
  }

  /**
   * Get bankDescriptor
   * @return bankDescriptor
  **/
  @ApiModelProperty(value = "")
  @Valid
  public List<BankDescriptor> getBankDescriptor() {
    return bankDescriptor;
  }

  public void setBankDescriptor(List<BankDescriptor> bankDescriptor) {
    this.bankDescriptor = bankDescriptor;
  }

  public BankSearchResponse keyword(String keyword) {
    this.keyword = keyword;
    return this;
  }

  /**
   * The bank search input string
   * @return keyword
  **/
  @ApiModelProperty(value = "The bank search input string")

  public String getKeyword() {
    return keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  public BankSearchResponse start(Integer start) {
    this.start = start;
    return this;
  }

  /**
   * The index of the first result
   * @return start
  **/
  @ApiModelProperty(value = "The index of the first result")

  public Integer getStart() {
    return start;
  }

  public void setStart(Integer start) {
    this.start = start;
  }

  public BankSearchResponse max(Integer max) {
    this.max = max;
    return this;
  }

  /**
   * The max number of entries to return with the response.
   * @return max
  **/
  @ApiModelProperty(value = "The max number of entries to return with the response.")

  public Integer getMax() {
    return max;
  }

  public void setMax(Integer max) {
    this.max = max;
  }

  public BankSearchResponse total(Integer total) {
    this.total = total;
    return this;
  }

  /**
   * The total count of entities found for the given search input.
   * @return total
  **/
  @ApiModelProperty(value = "The total count of entities found for the given search input.")

  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankSearchResponse bankSearchResponse = (BankSearchResponse) o;
    return Objects.equals(this.bankDescriptor, bankSearchResponse.bankDescriptor) &&
        Objects.equals(this.keyword, bankSearchResponse.keyword) &&
        Objects.equals(this.start, bankSearchResponse.start) &&
        Objects.equals(this.max, bankSearchResponse.max) &&
        Objects.equals(this.total, bankSearchResponse.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bankDescriptor, keyword, start, max, total);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankSearchResponse {\n");
    
    sb.append("    bankDescriptor: ").append(toIndentedString(bankDescriptor)).append("\n");
    sb.append("    keyword: ").append(toIndentedString(keyword)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
