/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.11).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package de.adorsys.opba.tppbankingapi.ais.resource;

import de.adorsys.opba.tppbankingapi.ais.model.AccountList;
import de.adorsys.opba.tppbankingapi.ais.model.AuthChallenge;
import de.adorsys.opba.tppbankingapi.ais.model.GeneralError;
import java.time.LocalDate;
import de.adorsys.opba.tppbankingapi.ais.model.TransactionsResponse;
import java.util.UUID;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-01-20T14:29:10.830Z[UTC]")
@Api(value = "TppBankingApiAccountInformationServiceAis", description = "the TppBankingApiAccountInformationServiceAis API")
public interface TppBankingApiAccountInformationServiceAisApi {

    Logger log = LoggerFactory.getLogger(TppBankingApiAccountInformationServiceAisApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "Provides list of available accounts", nickname = "getAccounts", notes = "Read the identifiers of the available payment accounts. It is assumed that a consent of the PSU to this access is already given and stored on the TPP system. The addressed list of accounts depends then on the PSU and Consent information, stored respectively the OAuth2 access token. Returns all identifiers of the accounts, to which an account access has been granted to by the PSU. In addition, relevant information about the accounts and hyperlinks to corresponding account information resources are provided if a related consent has been already granted.", response = AccountList.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")    }, tags={ "TPP Banking API Account information service (AIS)", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = AccountList.class),
        @ApiResponse(code = 303, message = "User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response. ", response = AuthChallenge.class),
        @ApiResponse(code = 401, message = "Unauthorised. Access token absent or invalid. ", response = GeneralError.class) })
    @ApiImplicitParams({
    @ApiImplicitParam(name = "authorization", value = "Unique Token that identifies FinTech Session for this request. ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "psUConsentSession", value = "Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestID", value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType = "UUID", paramType = "header")    })
    @RequestMapping(value = "/v1/banking/ais/accounts",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<AccountList> _getAccounts(@ApiParam(value = "Unique Token that identifies FinTech Session for this request. " ,required=true) @RequestHeader(value="Authorization", required=true) String authorization,@ApiParam(value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. " ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. " ) @RequestHeader(value="PSU-Consent-Session", required=false) String psUConsentSession) {
        return getAccounts(authorization, xRequestID, psUConsentSession);
    }

    // Override this method
    default ResponseEntity<AccountList> getAccounts(String authorization,UUID xRequestID,String psUConsentSession) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"accounts\" : [ {\n    \"cashAccountType\" : \"cashAccountType\",\n    \"resourceId\" : \"resourceId\",\n    \"product\" : \"product\",\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"_links\" : {\n      \"balances\" : {\n        \"href\" : \"https://www.example.com/path/resource?parameter=value\"\n      }\n    },\n    \"usage\" : \"PRIV\",\n    \"ownerName\" : \"ownerName\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"name\" : \"name\",\n    \"linkedAccounts\" : \"linkedAccounts\",\n    \"currency\" : \"EUR\",\n    \"details\" : \"details\",\n    \"ownerAddress\" : {\n      \"street\" : \"rue blue\",\n      \"buildingnNumber\" : \"89\",\n      \"city\" : \"Paris\",\n      \"postalCode\" : \"75000\",\n      \"country\" : \"FR\"\n    },\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\",\n    \"bic\" : \"AAAADEBBXXX\",\n    \"status\" : \"enabled\"\n  }, {\n    \"cashAccountType\" : \"cashAccountType\",\n    \"resourceId\" : \"resourceId\",\n    \"product\" : \"product\",\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"_links\" : {\n      \"balances\" : {\n        \"href\" : \"https://www.example.com/path/resource?parameter=value\"\n      }\n    },\n    \"usage\" : \"PRIV\",\n    \"ownerName\" : \"ownerName\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"name\" : \"name\",\n    \"linkedAccounts\" : \"linkedAccounts\",\n    \"currency\" : \"EUR\",\n    \"details\" : \"details\",\n    \"ownerAddress\" : {\n      \"street\" : \"rue blue\",\n      \"buildingnNumber\" : \"89\",\n      \"city\" : \"Paris\",\n      \"postalCode\" : \"75000\",\n      \"country\" : \"FR\"\n    },\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\",\n    \"bic\" : \"AAAADEBBXXX\",\n    \"status\" : \"enabled\"\n  } ]\n}", AccountList.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Provides list of transactions by given account", nickname = "getTransactions", notes = "This operation shows how to override the global security defined above, as we want to open it up for all users.", response = TransactionsResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")    }, tags={ "TPP Banking API Account information service (AIS)", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = TransactionsResponse.class),
        @ApiResponse(code = 303, message = "User authorisation session mandated. Agent shall redirect the user to the Authorisation URI provided in response. ", response = AuthChallenge.class),
        @ApiResponse(code = 401, message = "Unauthorised. Access token absent or invalid. ", response = GeneralError.class) })
    @ApiImplicitParams({
    @ApiImplicitParam(name = "authorization", value = "Unique Token that identifies FinTech Session for this request. ", required=true, dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "psUConsentSession", value = "Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. ",  dataType = "String", paramType = "header"),    @ApiImplicitParam(name = "xRequestID", value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType = "UUID", paramType = "header")    })
    @RequestMapping(value = "/v1/banking/ais/accounts/{account-id}/transactions",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<TransactionsResponse> _getTransactions(@ApiParam(value = "",required=true) @PathVariable("account-id") String accountId,@ApiParam(value = "Unique Token that identifies FinTech Session for this request. " ,required=true) @RequestHeader(value="Authorization", required=true) String authorization,@ApiParam(value = "Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. " ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Unique Token that identifies PSU Consent Session for this request, if it is already available for given PSU by Fintech through previous requests. This Token is not designed to be parsed at Fintech side. " ) @RequestHeader(value="PSU-Consent-Session", required=false) String psUConsentSession,@ApiParam(value = "Conditional: Starting date (inclusive the date dateFrom) of the transaction list, mandated if no delta access is required.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value = "dateFrom", required = false) LocalDate dateFrom,@ApiParam(value = "End date (inclusive the data dateTo) of the transaction list, default is \"now\" if not given.  Might be ignored if a delta function is used.  For booked transactions, the relevant date is the booking date.  For pending transactions, the relevant date is the entry date, which may not be transparent neither in this API nor other channels of the ASPSP. ") @Valid @RequestParam(value = "dateTo", required = false) LocalDate dateTo,@ApiParam(value = "This data attribute is indicating that the AISP is in favour to get all transactions after the transaction with identification entryReferenceFrom alternatively to the above defined period. This is a implementation of a delta access. If this data element is contained, the entries \"dateFrom\" and \"dateTo\" might be ignored by the ASPSP if a delta report is supported.  Optional if supported by API provider. ") @Valid @RequestParam(value = "entryReferenceFrom", required = false) String entryReferenceFrom,@ApiParam(value = "Permitted codes are   * \"booked\",   * \"pending\" and   * \"both\" To support the \"pending\" and \"both\" feature is optional for the ASPSP, Error code if not supported in the online banking frontend Default is \"booked\" ", allowableValues = "booked, pending, both") @Valid @RequestParam(value = "bookingStatus", required = false) String bookingStatus,@ApiParam(value = "This data attribute is indicating that the AISP is in favour to get all transactions after the last report access for this PSU on the addressed account. This is another implementation of a delta access-report.  This delta indicator might be rejected by the ASPSP if this function is not supported.  Optional if supported by API provider ") @Valid @RequestParam(value = "deltaList", required = false) Boolean deltaList) {
        return getTransactions(accountId, authorization, xRequestID, psUConsentSession, dateFrom, dateTo, entryReferenceFrom, bookingStatus, deltaList);
    }

    // Override this method
    default ResponseEntity<TransactionsResponse> getTransactions(String accountId,String authorization,UUID xRequestID,String psUConsentSession,LocalDate dateFrom,LocalDate dateTo,String entryReferenceFrom,String bookingStatus,Boolean deltaList) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"transactions\" : {\n    \"booked\" : [ {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    }, {\n      \"additionalInformation\" : \"additionalInformation\",\n      \"creditorName\" : \"Creditor Name\",\n      \"remittanceInformationStructured\" : \"remittanceInformationStructured\",\n      \"ultimateCreditor\" : \"Ultimate Creditor\",\n      \"bankTransactionCode\" : \"PMNT-RCDT-ESCT\",\n      \"debtorName\" : \"Debtor Name\",\n      \"valueDate\" : \"2000-01-23\",\n      \"endToEndId\" : \"endToEndId\",\n      \"transactionId\" : \"transactionId\",\n      \"currencyExchange\" : [ {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      }, {\n        \"contractIdentification\" : \"contractIdentification\",\n        \"exchangeRate\" : \"exchangeRate\",\n        \"unitCurrency\" : \"unitCurrency\",\n        \"quotationDate\" : \"2000-01-23\"\n      } ],\n      \"ultimateDebtor\" : \"Ultimate Debtor\",\n      \"mandateId\" : \"mandateId\",\n      \"transactionAmount\" : {\n        \"currency\" : \"EUR\",\n        \"amount\" : \"123\"\n      },\n      \"purposeCode\" : \"BKDF\",\n      \"proprietaryBankTransactionCode\" : \"proprietaryBankTransactionCode\",\n      \"bookingDate\" : \"2000-01-23\",\n      \"remittanceInformationUnstructured\" : \"Ref Number Merchant\",\n      \"checkId\" : \"checkId\",\n      \"entryReference\" : \"entryReference\",\n      \"creditorId\" : \"creditorId\"\n    } ]\n  },\n  \"account\" : {\n    \"bban\" : \"BARC12345612345678\",\n    \"maskedPan\" : \"123456xxxxxx1234\",\n    \"iban\" : \"FR7612345987650123456789014\",\n    \"currency\" : \"EUR\",\n    \"pan\" : \"5409050000000000\",\n    \"msisdn\" : \"+49 170 1234567\"\n  }\n}", TransactionsResponse.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default TppBankingApiAccountInformationServiceAisApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
