package de.adorsys.opba.tppbankingapi.ais.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import de.adorsys.opba.tppbankingapi.ais.model.HrefType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * The PSU shall perform the authorisation procedures at ASPSP through the interface provided by the given link. Additional get parameters &#x27;Agent-Callback-OK&#x27; and &#x27;Agent-Callback-NOK&#x27; may be added to the link by the agent to get notified about the procedure end. 
 */
@ApiModel(description = "The PSU shall perform the authorisation procedures at ASPSP through the interface provided by the given link. Additional get parameters 'Agent-Callback-OK' and 'Agent-Callback-NOK' may be added to the link by the agent to get notified about the procedure end. ")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-01-20T14:29:10.830Z[UTC]")
public class AuthChallenge   {
  @JsonProperty("web")
  private HrefType web = null;

  public AuthChallenge web(HrefType web) {
    this.web = web;
    return this;
  }

  /**
   * Get web
   * @return web
  **/
  @ApiModelProperty(value = "")

  @Valid
  public HrefType getWeb() {
    return web;
  }

  public void setWeb(HrefType web) {
    this.web = web;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthChallenge authChallenge = (AuthChallenge) o;
    return Objects.equals(this.web, authChallenge.web);
  }

  @Override
  public int hashCode() {
    return Objects.hash(web);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthChallenge {\n");
    
    sb.append("    web: ").append(toIndentedString(web)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
