/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped.paymentaccess;

import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.Payment;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.PaymentRepository;
import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.api.services.scoped.consent.PaymentAccess;
import de.adorsys.opba.protocol.api.services.scoped.consent.ProtocolFacingPayment;
import de.adorsys.opba.protocol.facade.services.scoped.paymentaccess.ProtocolFacingPaymentImpl;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class PsuPaymentAccess
implements PaymentAccess {
    private final Psu psu;
    private final Bank aspsp;
    private final EncryptionService encryptionService;
    private final ServiceSession serviceSession;
    private final PaymentRepository paymentRepository;

    public boolean isFinTechScope() {
        return false;
    }

    public ProtocolFacingPayment createDoNotPersist() {
        Payment newPayment = Payment.builder().serviceSession(this.serviceSession).psu(this.psu).aspsp(this.aspsp).build();
        return new ProtocolFacingPaymentImpl(newPayment, this.encryptionService);
    }

    public void save(ProtocolFacingPayment payment) {
        this.paymentRepository.save((Object)((ProtocolFacingPaymentImpl)payment).getPayment());
    }

    public void delete(ProtocolFacingPayment payment) {
        this.paymentRepository.delete((Object)((ProtocolFacingPaymentImpl)payment).getPayment());
    }

    public List<ProtocolFacingPayment> findByCurrentServiceSessionOrderByModifiedDesc() {
        return this.paymentRepository.findByServiceSessionIdOrderByModifiedAtDesc(this.serviceSession.getId()).stream().map(it -> new ProtocolFacingPaymentImpl((Payment)it, this.encryptionService)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"psu", "aspsp", "encryptionService", "serviceSession", "paymentRepository"})
    @Generated
    public PsuPaymentAccess(Psu psu, Bank aspsp, EncryptionService encryptionService, ServiceSession serviceSession, PaymentRepository paymentRepository) {
        this.psu = psu;
        this.aspsp = aspsp;
        this.encryptionService = encryptionService;
        this.serviceSession = serviceSession;
        this.paymentRepository = paymentRepository;
    }
}

