/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped.paymentaccess;

import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.psu.PsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.PaymentRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechOnlyPubKeyRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyRepository;
import de.adorsys.opba.db.repository.jpa.psu.PsuAspspPrvKeyRepository;
import de.adorsys.opba.protocol.api.services.scoped.consent.PaymentAccess;
import de.adorsys.opba.protocol.facade.config.encryption.PsuEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import de.adorsys.opba.protocol.facade.services.scoped.paymentaccess.AnonymousPsuPaymentAccess;
import de.adorsys.opba.protocol.facade.services.scoped.paymentaccess.FintechPaymentAccess;
import de.adorsys.opba.protocol.facade.services.scoped.paymentaccess.PsuPaymentAccess;
import java.beans.ConstructorProperties;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class PaymentAccessFactory {
    private final EntityManager entityManager;
    private final PsuAspspPrvKeyRepository prvKeyRepository;
    private final FintechOnlyPubKeyRepository fintechPubKeys;
    private final FintechSecureStorage fintechVault;
    private final PsuEncryptionServiceProvider psuEncryption;
    private final FintechPsuAspspPrvKeyRepository fintechPsuAspspPrvKeyRepository;
    private final PaymentRepository paymentRepository;

    public PaymentAccess paymentForPsuAndAspsp(Psu psu, Bank aspsp, ServiceSession session) {
        PsuAspspPrvKey prvKey = (PsuAspspPrvKey)this.prvKeyRepository.findByPsuIdAndAspspId(psu.getId().longValue(), aspsp.getId().longValue()).orElseThrow(() -> new IllegalStateException("No public key for: " + psu.getId()));
        return new PsuPaymentAccess(psu, aspsp, this.psuEncryption.forPublicKey(prvKey.getId(), prvKey.getPubKey().getKey()), session, this.paymentRepository);
    }

    public PaymentAccess paymentForAnonymousPsu(Fintech fintech, Bank aspsp, ServiceSession session) {
        return new AnonymousPsuPaymentAccess(aspsp, fintech, this.fintechPubKeys, this.psuEncryption, session, this.paymentRepository);
    }

    public PaymentAccess paymentForFintech(Fintech fintech, ServiceSession session, Supplier<char[]> fintechPassword) {
        return new FintechPaymentAccess(fintech, this.psuEncryption, this.fintechPsuAspspPrvKeyRepository, this.fintechVault, this.paymentRepository, this.entityManager, session.getId(), fintechPassword);
    }

    @ConstructorProperties(value={"entityManager", "prvKeyRepository", "fintechPubKeys", "fintechVault", "psuEncryption", "fintechPsuAspspPrvKeyRepository", "paymentRepository"})
    @Generated
    public PaymentAccessFactory(EntityManager entityManager, PsuAspspPrvKeyRepository prvKeyRepository, FintechOnlyPubKeyRepository fintechPubKeys, FintechSecureStorage fintechVault, PsuEncryptionServiceProvider psuEncryption, FintechPsuAspspPrvKeyRepository fintechPsuAspspPrvKeyRepository, PaymentRepository paymentRepository) {
        this.entityManager = entityManager;
        this.prvKeyRepository = prvKeyRepository;
        this.fintechPubKeys = fintechPubKeys;
        this.fintechVault = fintechVault;
        this.psuEncryption = psuEncryption;
        this.fintechPsuAspspPrvKeyRepository = fintechPsuAspspPrvKeyRepository;
        this.paymentRepository = paymentRepository;
    }
}

