/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped.paymentaccess;

import de.adorsys.opba.db.domain.entity.Payment;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechPrvKey;
import de.adorsys.opba.db.domain.entity.fintech.FintechPsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.PaymentRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyRepository;
import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.api.services.scoped.consent.PaymentAccess;
import de.adorsys.opba.protocol.api.services.scoped.consent.ProtocolFacingPayment;
import de.adorsys.opba.protocol.facade.config.encryption.PsuEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import de.adorsys.opba.protocol.facade.services.scoped.paymentaccess.ProtocolFacingPaymentImpl;
import java.beans.ConstructorProperties;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;

public class FintechPaymentAccess
implements PaymentAccess {
    private final Fintech fintech;
    private final PsuEncryptionServiceProvider encryptionService;
    private final FintechPsuAspspPrvKeyRepository keys;
    private final FintechSecureStorage fintechVault;
    private final PaymentRepository payments;
    private final EntityManager entityManager;
    private final UUID serviceSessionId;
    private final Supplier<char[]> fintechPassword;

    public boolean isFinTechScope() {
        return true;
    }

    public ProtocolFacingPayment createDoNotPersist() {
        throw new IllegalStateException("No PSU present - can't create payment");
    }

    public void save(ProtocolFacingPayment consent) {
        throw new IllegalStateException("No PSU present - can't save payment");
    }

    public void delete(ProtocolFacingPayment consent) {
        throw new IllegalStateException("No PSU present - can't delete payment");
    }

    public List<ProtocolFacingPayment> findByCurrentServiceSessionOrderByModifiedDesc() {
        ServiceSession serviceSession = (ServiceSession)this.entityManager.find(ServiceSession.class, (Object)this.serviceSessionId);
        if (null == serviceSession || null == serviceSession.getAuthSession()) {
            return Collections.emptyList();
        }
        List payments = this.payments.findByServiceSessionIdOrderByModifiedAtDesc(serviceSession.getId());
        if (payments.isEmpty()) {
            return Collections.emptyList();
        }
        EncryptionService psuEncryptionService = !serviceSession.getAuthSession().isPsuAnonymous() ? this.psuKeyBasedEncryptionService(serviceSession) : null;
        return payments.stream().map(it -> this.toProtocolFacingPayment((Payment)it, serviceSession, psuEncryptionService)).collect(Collectors.toList());
    }

    private ProtocolFacingPaymentImpl toProtocolFacingPayment(Payment payment, ServiceSession session, EncryptionService psuEncryptionService) {
        if (null == payment.getPsu()) {
            return this.anonymousPayment(payment);
        }
        return this.psuPayment(payment, session, psuEncryptionService);
    }

    private ProtocolFacingPaymentImpl psuPayment(Payment payment, ServiceSession session, EncryptionService psuEncryptionService) {
        if (!payment.getPsu().getId().equals(session.getAuthSession().getPsu().getId())) {
            throw new IllegalStateException(String.format("Payment %s is for %d but session is for %d", payment.getId().toString(), payment.getPsu().getId(), session.getAuthSession().getPsu().getId()));
        }
        return new ProtocolFacingPaymentImpl(payment, psuEncryptionService);
    }

    private ProtocolFacingPaymentImpl anonymousPayment(Payment payment) {
        return new ProtocolFacingPaymentImpl(payment, this.anonymousEncryptionService(payment.getFintechPubKey().getPrvKey()));
    }

    private EncryptionService psuKeyBasedEncryptionService(ServiceSession session) {
        Optional psuAspspPrivateKey = this.keys.findByFintechIdAndPsuIdAndAspspId(this.fintech.getId().longValue(), session.getAuthSession().getPsu().getId().longValue(), session.getAuthSession().getAction().getBankProfile().getBank().getId().longValue());
        if (!psuAspspPrivateKey.isPresent()) {
            return null;
        }
        PrivateKey psuAspspKey = this.fintechVault.psuAspspKeyFromPrivate(session, this.fintech, this.fintechPassword);
        return this.encryptionService.forPrivateKey(((FintechPsuAspspPrvKey)psuAspspPrivateKey.get()).getId(), psuAspspKey);
    }

    private EncryptionService anonymousEncryptionService(FintechPrvKey prvKey) {
        PrivateKey psuAspspKey = this.fintechVault.fintechOnlyPrvKeyFromPrivate(prvKey, this.fintech, this.fintechPassword);
        return this.encryptionService.forPrivateKey(prvKey.getId(), psuAspspKey);
    }

    @ConstructorProperties(value={"fintech", "encryptionService", "keys", "fintechVault", "payments", "entityManager", "serviceSessionId", "fintechPassword"})
    @Generated
    public FintechPaymentAccess(Fintech fintech, PsuEncryptionServiceProvider encryptionService, FintechPsuAspspPrvKeyRepository keys, FintechSecureStorage fintechVault, PaymentRepository payments, EntityManager entityManager, UUID serviceSessionId, Supplier<char[]> fintechPassword) {
        this.fintech = fintech;
        this.encryptionService = encryptionService;
        this.keys = keys;
        this.fintechVault = fintechVault;
        this.payments = payments;
        this.entityManager = entityManager;
        this.serviceSessionId = serviceSessionId;
        this.fintechPassword = fintechPassword;
    }
}

