/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped.paymentaccess;

import com.google.common.collect.Iterables;
import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.Payment;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechPubKey;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.PaymentRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechOnlyPubKeyRepository;
import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.api.services.scoped.consent.PaymentAccess;
import de.adorsys.opba.protocol.api.services.scoped.consent.ProtocolFacingPayment;
import de.adorsys.opba.protocol.facade.config.encryption.PsuEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.services.scoped.paymentaccess.ProtocolFacingPaymentImpl;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;

public class AnonymousPsuPaymentAccess
implements PaymentAccess {
    private final Bank aspsp;
    private final Fintech fintech;
    private final FintechOnlyPubKeyRepository pubKeys;
    private final PsuEncryptionServiceProvider psuEncryption;
    private final ServiceSession serviceSession;
    private final PaymentRepository paymentRepository;

    public boolean isFinTechScope() {
        return false;
    }

    public ProtocolFacingPayment createDoNotPersist() {
        Collection keys = this.pubKeys.findByFintech(this.fintech);
        FintechPubKey fintechPubKey = (FintechPubKey)Iterables.get((Iterable)keys, (int)ThreadLocalRandom.current().nextInt(0, keys.size() - 1));
        Payment newPayment = Payment.builder().serviceSession(this.serviceSession).aspsp(this.aspsp).fintechPubKey(fintechPubKey).build();
        return new ProtocolFacingPaymentImpl(newPayment, this.anonymousEncryptionServiceBasedOnRandomKeyFromFintech(fintechPubKey));
    }

    public void save(ProtocolFacingPayment payment) {
        this.paymentRepository.save((Object)((ProtocolFacingPaymentImpl)payment).getPayment());
    }

    public void delete(ProtocolFacingPayment consent) {
        throw new IllegalStateException("Not implemented");
    }

    public List<ProtocolFacingPayment> findByCurrentServiceSessionOrderByModifiedDesc() {
        throw new IllegalStateException("Not implemented");
    }

    private EncryptionService anonymousEncryptionServiceBasedOnRandomKeyFromFintech(FintechPubKey fintechPubKey) {
        return this.psuEncryption.forPublicKey(fintechPubKey.getId(), fintechPubKey.getKey());
    }

    @ConstructorProperties(value={"aspsp", "fintech", "pubKeys", "psuEncryption", "serviceSession", "paymentRepository"})
    @Generated
    public AnonymousPsuPaymentAccess(Bank aspsp, Fintech fintech, FintechOnlyPubKeyRepository pubKeys, PsuEncryptionServiceProvider psuEncryption, ServiceSession serviceSession, PaymentRepository paymentRepository) {
        this.aspsp = aspsp;
        this.fintech = fintech;
        this.pubKeys = pubKeys;
        this.psuEncryption = psuEncryption;
        this.serviceSession = serviceSession;
        this.paymentRepository = paymentRepository;
    }
}

