/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped.consentaccess;

import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.Consent;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.ConsentRepository;
import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.api.services.scoped.consent.ConsentAccess;
import de.adorsys.opba.protocol.api.services.scoped.consent.ProtocolFacingConsent;
import de.adorsys.opba.protocol.facade.services.scoped.ConsentAccessUtil;
import de.adorsys.opba.protocol.facade.services.scoped.consentaccess.ProtocolFacingConsentImpl;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class PsuConsentAccess
implements ConsentAccess {
    private final Psu psu;
    private final Bank aspsp;
    private final EncryptionService encryptionService;
    private final ServiceSession serviceSession;
    private final ConsentRepository consentRepository;

    public boolean isFinTechScope() {
        return false;
    }

    public ProtocolFacingConsent createDoNotPersist() {
        Consent newConsent = Consent.builder().serviceSession(this.serviceSession).psu(this.psu).aspsp(this.aspsp).build();
        return new ProtocolFacingConsentImpl(newConsent, this.encryptionService);
    }

    public void save(ProtocolFacingConsent consent) {
        this.consentRepository.save((Object)((ProtocolFacingConsentImpl)consent).getConsent());
    }

    public void delete(ProtocolFacingConsent consent) {
        this.consentRepository.delete((Object)((ProtocolFacingConsentImpl)consent).getConsent());
    }

    public Optional<ProtocolFacingConsent> findSingleByCurrentServiceSession() {
        return ConsentAccessUtil.getProtocolFacingConsent(this.findByCurrentServiceSessionOrderByModifiedDesc());
    }

    public List<ProtocolFacingConsent> findByCurrentServiceSessionOrderByModifiedDesc() {
        return this.consentRepository.findByServiceSessionIdOrderByModifiedAtDesc(this.serviceSession.getId()).stream().map(it -> new ProtocolFacingConsentImpl((Consent)it, this.encryptionService)).collect(Collectors.toList());
    }

    public Collection<ProtocolFacingConsent> getAvailableConsentsForCurrentPsu() {
        return this.consentRepository.findByPsu(this.psu).stream().map(it -> new ProtocolFacingConsentImpl((Consent)it, this.encryptionService)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"psu", "aspsp", "encryptionService", "serviceSession", "consentRepository"})
    @Generated
    public PsuConsentAccess(Psu psu, Bank aspsp, EncryptionService encryptionService, ServiceSession serviceSession, ConsentRepository consentRepository) {
        this.psu = psu;
        this.aspsp = aspsp;
        this.encryptionService = encryptionService;
        this.serviceSession = serviceSession;
        this.consentRepository = consentRepository;
    }
}

