/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped.consentaccess;

import de.adorsys.opba.db.domain.entity.Consent;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechPsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.ConsentRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyRepository;
import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.api.services.scoped.consent.ConsentAccess;
import de.adorsys.opba.protocol.api.services.scoped.consent.ProtocolFacingConsent;
import de.adorsys.opba.protocol.facade.config.encryption.PsuEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import de.adorsys.opba.protocol.facade.services.scoped.ConsentAccessUtil;
import de.adorsys.opba.protocol.facade.services.scoped.consentaccess.ProtocolFacingConsentImpl;
import java.beans.ConstructorProperties;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;

public class FintechConsentAccess
implements ConsentAccess {
    private final Fintech fintech;
    private final PsuEncryptionServiceProvider encryptionService;
    private final FintechPsuAspspPrvKeyRepository keys;
    private final FintechSecureStorage fintechVault;
    private final ConsentRepository consents;
    private final EntityManager entityManager;
    private final UUID serviceSessionId;
    private final Supplier<char[]> fintechPassword;

    public boolean isFinTechScope() {
        return true;
    }

    public ProtocolFacingConsent createDoNotPersist() {
        throw new IllegalStateException("No PSU present - can't create consent");
    }

    public void save(ProtocolFacingConsent consent) {
        throw new IllegalStateException("No PSU present - can't save consent");
    }

    public void delete(ProtocolFacingConsent consent) {
        throw new IllegalStateException("No PSU present - can't delete consent");
    }

    public Optional<ProtocolFacingConsent> findSingleByCurrentServiceSession() {
        return ConsentAccessUtil.getProtocolFacingConsent(this.findByCurrentServiceSessionOrderByModifiedDesc());
    }

    public List<ProtocolFacingConsent> findByCurrentServiceSessionOrderByModifiedDesc() {
        ServiceSession serviceSession = (ServiceSession)this.entityManager.find(ServiceSession.class, (Object)this.serviceSessionId);
        if (null == serviceSession || null == serviceSession.getAuthSession() || null == serviceSession.getAuthSession().getPsu()) {
            return Collections.emptyList();
        }
        Optional psuAspspPrivateKey = this.keys.findByFintechIdAndPsuIdAndAspspId(this.fintech.getId().longValue(), serviceSession.getAuthSession().getPsu().getId().longValue(), serviceSession.getAuthSession().getAction().getBankProfile().getBank().getId().longValue());
        List consent = this.consents.findByServiceSessionIdOrderByModifiedAtDesc(serviceSession.getId());
        if (!psuAspspPrivateKey.isPresent() || consent.isEmpty()) {
            return Collections.emptyList();
        }
        PrivateKey psuAspspKey = this.fintechVault.psuAspspKeyFromPrivate(serviceSession, this.fintech, this.fintechPassword);
        EncryptionService enc = this.encryptionService.forPrivateKey(((FintechPsuAspspPrvKey)psuAspspPrivateKey.get()).getId(), psuAspspKey);
        return consent.stream().map(it -> new ProtocolFacingConsentImpl((Consent)it, enc)).collect(Collectors.toList());
    }

    public Collection<ProtocolFacingConsent> getAvailableConsentsForCurrentPsu() {
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"fintech", "encryptionService", "keys", "fintechVault", "consents", "entityManager", "serviceSessionId", "fintechPassword"})
    @Generated
    public FintechConsentAccess(Fintech fintech, PsuEncryptionServiceProvider encryptionService, FintechPsuAspspPrvKeyRepository keys, FintechSecureStorage fintechVault, ConsentRepository consents, EntityManager entityManager, UUID serviceSessionId, Supplier<char[]> fintechPassword) {
        this.fintech = fintech;
        this.encryptionService = encryptionService;
        this.keys = keys;
        this.fintechVault = fintechVault;
        this.consents = consents;
        this.entityManager = entityManager;
        this.serviceSessionId = serviceSessionId;
        this.fintechPassword = fintechPassword;
    }
}

