/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped.consentaccess;

import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.psu.PsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.ConsentRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyRepository;
import de.adorsys.opba.db.repository.jpa.psu.PsuAspspPrvKeyRepository;
import de.adorsys.opba.protocol.api.services.scoped.consent.ConsentAccess;
import de.adorsys.opba.protocol.facade.config.encryption.PsuEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import de.adorsys.opba.protocol.facade.services.scoped.consentaccess.FintechConsentAccess;
import de.adorsys.opba.protocol.facade.services.scoped.consentaccess.PsuConsentAccess;
import java.beans.ConstructorProperties;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ConsentAccessFactory {
    private final EntityManager entityManager;
    private final PsuAspspPrvKeyRepository prvKeyRepository;
    private final FintechSecureStorage fintechVault;
    private final PsuEncryptionServiceProvider psuEncryption;
    private final FintechPsuAspspPrvKeyRepository fintechPsuAspspPrvKeyRepository;
    private final ConsentRepository consentRepository;

    public ConsentAccess consentForPsuAndAspsp(Psu psu, Bank aspsp, ServiceSession session) {
        PsuAspspPrvKey prvKey = (PsuAspspPrvKey)this.prvKeyRepository.findByPsuIdAndAspspId(psu.getId().longValue(), aspsp.getId().longValue()).orElseThrow(() -> new IllegalStateException("No public key for: " + psu.getId()));
        return new PsuConsentAccess(psu, aspsp, this.psuEncryption.forPublicKey(prvKey.getId(), prvKey.getPubKey().getKey()), session, this.consentRepository);
    }

    public ConsentAccess consentForFintech(Fintech fintech, ServiceSession session, Supplier<char[]> fintechPassword) {
        return new FintechConsentAccess(fintech, this.psuEncryption, this.fintechPsuAspspPrvKeyRepository, this.fintechVault, this.consentRepository, this.entityManager, session.getId(), fintechPassword);
    }

    @ConstructorProperties(value={"entityManager", "prvKeyRepository", "fintechVault", "psuEncryption", "fintechPsuAspspPrvKeyRepository", "consentRepository"})
    @Generated
    public ConsentAccessFactory(EntityManager entityManager, PsuAspspPrvKeyRepository prvKeyRepository, FintechSecureStorage fintechVault, PsuEncryptionServiceProvider psuEncryption, FintechPsuAspspPrvKeyRepository fintechPsuAspspPrvKeyRepository, ConsentRepository consentRepository) {
        this.entityManager = entityManager;
        this.prvKeyRepository = prvKeyRepository;
        this.fintechVault = fintechVault;
        this.psuEncryption = psuEncryption;
        this.fintechPsuAspspPrvKeyRepository = fintechPsuAspspPrvKeyRepository;
        this.consentRepository = consentRepository;
    }
}

