/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.scoped;

import com.google.common.cache.CacheBuilder;
import de.adorsys.opba.db.domain.entity.BankProfile;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.protocol.api.common.CurrentBankProfile;
import de.adorsys.opba.protocol.api.common.CurrentFintechProfile;
import de.adorsys.opba.protocol.api.fintechspec.ApiConsumerConfig;
import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.api.services.scoped.RequestScoped;
import de.adorsys.opba.protocol.api.services.scoped.RequestScopedServicesProvider;
import de.adorsys.opba.protocol.api.services.scoped.consent.ConsentAccess;
import de.adorsys.opba.protocol.api.services.scoped.consent.PaymentAccess;
import de.adorsys.opba.protocol.api.services.scoped.transientdata.TransientStorage;
import de.adorsys.opba.protocol.api.services.scoped.validation.FieldsToIgnoreLoader;
import de.adorsys.opba.protocol.facade.config.encryption.ConsentAuthorizationEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.SecretKeyWithIv;
import de.adorsys.opba.protocol.facade.services.scoped.IgnoreFieldsLoaderFactory;
import de.adorsys.opba.protocol.facade.services.scoped.consentaccess.ConsentAccessFactory;
import de.adorsys.opba.protocol.facade.services.scoped.paymentaccess.PaymentAccessFactory;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RequestScopedProvider
implements RequestScopedServicesProvider {
    private final Map<String, InternalRequestScoped> memoizedProviders;
    private final ConsentAccessFactory consentAccessProvider;
    private final PaymentAccessFactory paymentAccessProvider;
    private final IgnoreFieldsLoaderFactory ignoreFieldsLoaderFactory;
    private final ApiConsumerConfig fintechConfig;

    public RequestScopedProvider(@Qualifier(value="facade-cache-builder") CacheBuilder cacheBuilder, ConsentAccessFactory consentAccessProvider, PaymentAccessFactory paymentAccessProvider, IgnoreFieldsLoaderFactory ignoreFieldsLoaderFactory, ApiConsumerConfig fintechConfig) {
        this.memoizedProviders = cacheBuilder.build().asMap();
        this.consentAccessProvider = consentAccessProvider;
        this.paymentAccessProvider = paymentAccessProvider;
        this.ignoreFieldsLoaderFactory = ignoreFieldsLoaderFactory;
        this.fintechConfig = fintechConfig;
    }

    public RequestScoped registerForFintechSession(Fintech fintech, BankProfile profile, ServiceSession session, long bankProtocolId, ConsentAuthorizationEncryptionServiceProvider encryptionServiceProvider, SecretKeyWithIv futureAuthorizationSessionKey, Supplier<char[]> fintechPassword) {
        ConsentAccess consentAccess = this.consentAccessProvider.consentForFintech(fintech, session, fintechPassword);
        PaymentAccess paymentAccess = this.paymentAccessProvider.paymentForFintech(fintech, session, fintechPassword);
        EncryptionService authorizationSessionEncService = this.sessionEncryption(encryptionServiceProvider, futureAuthorizationSessionKey);
        return this.doRegister(profile, (CurrentFintechProfile)this.fintechConfig.getConsumers().get(fintech.getGlobalId()), consentAccess, paymentAccess, authorizationSessionEncService, futureAuthorizationSessionKey, bankProtocolId);
    }

    public RequestScoped registerForPsuSession(AuthSession authSession, ConsentAuthorizationEncryptionServiceProvider encryptionServiceProvider, long bankProtocolId, SecretKeyWithIv key) {
        EncryptionService sessionEncryption = this.sessionEncryption(encryptionServiceProvider, key);
        ConsentAccess consentAccess = this.getPsuConsentAccess(authSession);
        PaymentAccess paymentAccess = this.getPsuPaymentAccess(authSession);
        return this.doRegister(authSession.getAction().getBankProfile(), (CurrentFintechProfile)this.fintechConfig.getConsumers().get(authSession.getFintechUser().getFintech().getGlobalId()), consentAccess, paymentAccess, sessionEncryption, key, bankProtocolId);
    }

    private ConsentAccess getPsuConsentAccess(AuthSession authSession) {
        if (authSession.isPsuAnonymous()) {
            return null;
        }
        return this.consentAccessProvider.consentForPsuAndAspsp(authSession.getPsu(), authSession.getAction().getBankProfile().getBank(), authSession.getParent());
    }

    private PaymentAccess getPsuPaymentAccess(AuthSession authSession) {
        if (authSession.isPsuAnonymous()) {
            if (null != authSession.getPsu()) {
                throw new IllegalStateException("Expected anonymous session");
            }
            return this.paymentAccessProvider.paymentForAnonymousPsu(authSession.getFintechUser().getFintech(), authSession.getAction().getBankProfile().getBank(), authSession.getParent());
        }
        return this.paymentAccessProvider.paymentForPsuAndAspsp(authSession.getPsu(), authSession.getAction().getBankProfile().getBank(), authSession.getParent());
    }

    public InternalRequestScoped deregister(RequestScoped requestScoped) {
        return this.memoizedProviders.remove(requestScoped.getEncryptionKeyId());
    }

    public RequestScoped findRegisteredByKeyId(String keyId) {
        return this.memoizedProviders.get(keyId);
    }

    private EncryptionService sessionEncryption(ConsentAuthorizationEncryptionServiceProvider encryptionServiceProvider, SecretKeyWithIv key) {
        return encryptionServiceProvider.forSecretKey(key);
    }

    @NotNull
    private RequestScoped doRegister(BankProfile bankProfile, CurrentFintechProfile fintechProfile, ConsentAccess consentAccess, PaymentAccess paymentAccess, EncryptionService encryptionService, SecretKeyWithIv key, Long protocolId) {
        InternalRequestScoped requestScoped = new InternalRequestScoped(encryptionService.getEncryptionKeyId(), key, (CurrentBankProfile)bankProfile, fintechProfile, consentAccess, paymentAccess, encryptionService, this.ignoreFieldsLoaderFactory.createIgnoreFieldsLoader(protocolId));
        this.memoizedProviders.put(requestScoped.getEncryptionKeyId(), requestScoped);
        return requestScoped;
    }

    private static class TransientStorageImpl
    implements TransientStorage {
        private final AtomicReference<Object> value = new AtomicReference();

        private TransientStorageImpl() {
        }

        @Generated
        public Object get() {
            return this.value.get();
        }

        @Generated
        public void set(Object arg0) {
            this.value.set(arg0);
        }

        @Generated
        public void lazySet(Object arg0) {
            this.value.lazySet(arg0);
        }

        @Generated
        public boolean compareAndSet(Object arg0, Object arg1) {
            return this.value.compareAndSet(arg0, arg1);
        }

        @Generated
        public boolean weakCompareAndSet(Object arg0, Object arg1) {
            return this.value.weakCompareAndSet(arg0, arg1);
        }

        @Generated
        public Object getAndSet(Object arg0) {
            return this.value.getAndSet(arg0);
        }

        @Generated
        public Object getAndUpdate(UnaryOperator<Object> arg0) {
            return this.value.getAndUpdate(arg0);
        }

        @Generated
        public Object updateAndGet(UnaryOperator<Object> arg0) {
            return this.value.updateAndGet(arg0);
        }

        @Generated
        public Object getAndAccumulate(Object arg0, BinaryOperator<Object> arg1) {
            return this.value.getAndAccumulate(arg0, arg1);
        }

        @Generated
        public Object accumulateAndGet(Object arg0, BinaryOperator<Object> arg1) {
            return this.value.accumulateAndGet(arg0, arg1);
        }
    }

    public static class InternalRequestScoped
    implements RequestScoped {
        private final TransientStorage transientStorage = new TransientStorageImpl();
        private final String encryptionKeyId;
        private final SecretKeyWithIv key;
        private final CurrentBankProfile bankProfile;
        private final CurrentFintechProfile fintechProfile;
        private final ConsentAccess consentAccess;
        private final PaymentAccess paymentAccess;
        private final EncryptionService encryptionService;
        private final FieldsToIgnoreLoader fieldsToIgnoreLoader;

        public CurrentBankProfile aspspProfile() {
            return this.bankProfile;
        }

        public CurrentFintechProfile fintechProfile() {
            return this.fintechProfile;
        }

        public ConsentAccess consentAccess() {
            return this.consentAccess;
        }

        public PaymentAccess paymentAccess() {
            return this.paymentAccess;
        }

        public EncryptionService encryption() {
            return this.encryptionService;
        }

        public TransientStorage transientStorage() {
            return this.transientStorage;
        }

        public FieldsToIgnoreLoader fieldsToIgnoreLoader() {
            return this.fieldsToIgnoreLoader;
        }

        @Generated
        public TransientStorage getTransientStorage() {
            return this.transientStorage;
        }

        @Generated
        public String getEncryptionKeyId() {
            return this.encryptionKeyId;
        }

        @Generated
        public SecretKeyWithIv getKey() {
            return this.key;
        }

        @Generated
        public CurrentBankProfile getBankProfile() {
            return this.bankProfile;
        }

        @Generated
        public CurrentFintechProfile getFintechProfile() {
            return this.fintechProfile;
        }

        @Generated
        public ConsentAccess getConsentAccess() {
            return this.consentAccess;
        }

        @Generated
        public PaymentAccess getPaymentAccess() {
            return this.paymentAccess;
        }

        @Generated
        public EncryptionService getEncryptionService() {
            return this.encryptionService;
        }

        @Generated
        public FieldsToIgnoreLoader getFieldsToIgnoreLoader() {
            return this.fieldsToIgnoreLoader;
        }

        @ConstructorProperties(value={"encryptionKeyId", "key", "bankProfile", "fintechProfile", "consentAccess", "paymentAccess", "encryptionService", "fieldsToIgnoreLoader"})
        @Generated
        public InternalRequestScoped(String encryptionKeyId, SecretKeyWithIv key, CurrentBankProfile bankProfile, CurrentFintechProfile fintechProfile, ConsentAccess consentAccess, PaymentAccess paymentAccess, EncryptionService encryptionService, FieldsToIgnoreLoader fieldsToIgnoreLoader) {
            this.encryptionKeyId = encryptionKeyId;
            this.key = key;
            this.bankProfile = bankProfile;
            this.fintechProfile = fintechProfile;
            this.consentAccess = consentAccess;
            this.paymentAccess = paymentAccess;
            this.encryptionService = encryptionService;
            this.fieldsToIgnoreLoader = fieldsToIgnoreLoader;
        }
    }
}

